/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon;

import com.github.mim1q.minecells.accessor.PlayerEntityAccessor;
import com.github.mim1q.minecells.entity.damage.MineCellsDamageSource;
import com.github.mim1q.minecells.item.weapon.interfaces.WeaponWithAbility;
import com.github.mim1q.minecells.item.weapon.melee.CustomMeleeWeapon;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.valuecalculators.ModValueCalculators;
import dev.mim1q.gimm1q.valuecalculators.ValueCalculator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5328;
import net.minecraft.class_638;

public class HattorisKatanaItem
extends CustomMeleeWeapon
implements WeaponWithAbility {
    private static final ValueCalculator ABILITY_DAMAGE_CALCULATOR = ModValueCalculators.of("melee/hattoris_katana", "ability_damage", 0.0);
    private static final ValueCalculator ABILITY_COOLDOWN_CALCULATOR = ModValueCalculators.of("melee/hattoris_katana", "ability_cooldown", 0.0);

    public HattorisKatanaItem(class_1792.class_1793 settings) {
        super("hattoris_katana", settings);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (world.method_8608()) {
            ParticleUtils.addAura((class_638)world, user.method_19538().method_1031(0.0, 1.0, 0.0), (class_2394)class_2398.field_11207, 1, 3.0, -0.2);
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user.method_31747()) {
            class_1657 player = (class_1657)user;
            player.method_7357().method_7906((class_1792)this, 20);
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (user.method_31747()) {
            class_1657 player = (class_1657)user;
            player.method_7357().method_7906((class_1792)this, this.getAbilityCooldown(stack, user));
            class_243 start = player.method_19538().method_1031(0.0, 0.25, 0.0);
            class_243 direction = player.method_5828(0.0f).method_18805(1.0, 0.0, 1.0).method_1029();
            class_243 hitPos = this.getHitPos(player, start, direction, 10.0).method_1020(direction.method_1021(0.5));
            this.damageEntities(world, stack, player, start, hitPos);
            if (world.method_8608()) {
                this.spawnTrailParticles(world, start, hitPos);
            } else {
                stack.method_7956(1, (class_1309)player, p -> p.method_20236(user.method_6058()));
                player.method_20620(hitPos.field_1352, hitPos.field_1351, hitPos.field_1350);
                ((PlayerEntityAccessor)player).setInvincibilityFrames(10);
            }
            user.method_5783(MineCellsSounds.KATANA_RELEASE, 2.0f, 1.0f);
        }
        return super.method_7861(stack, world, user);
    }

    private void spawnTrailParticles(class_1937 world, class_243 start, class_243 hitPos) {
        List<class_243> increments = this.getIncrements(start, hitPos, 20);
        for (class_243 increment : increments) {
            ParticleUtils.addAura((class_638)world, increment, (class_2394)class_2398.field_11207, 2, 3.0, -0.1);
            float speed = (float)(increment.method_1022(hitPos) / 200.0);
            ParticleUtils.addAura((class_638)world, increment, (class_2394)class_2398.field_17430, 3, 0.5, speed);
        }
        ParticleUtils.addParticle((class_638)world, (class_2394)class_2398.field_17909, start.method_1031(0.0, 1.0, 0.0), class_243.field_1353);
        ParticleUtils.addParticle((class_638)world, (class_2394)class_2398.field_17909, hitPos.method_1031(0.0, 1.0, 0.0), class_243.field_1353);
    }

    private class_243 getHitPos(class_1657 player, class_243 start, class_243 direction, double distance) {
        class_243 end = start.method_1019(direction.method_1021(distance));
        class_3965 hit1 = player.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        class_3965 hit2 = player.method_37908().method_17742(new class_3959(start.method_1031(0.0, 1.0, 0.0), end.method_1031(0.0, 1.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        return hit1.method_24801((class_1297)player) < hit2.method_24801((class_1297)player) ? hit1.method_17784().method_18805(1.0, 0.0, 1.0).method_1031(0.0, player.method_23318(), 0.0) : hit2.method_17784().method_18805(1.0, 0.0, 1.0).method_1031(0.0, player.method_23318(), 0.0);
    }

    private List<class_243> getIncrements(class_243 start, class_243 end, int count) {
        ArrayList<class_243> result = new ArrayList<class_243>();
        class_243 diff = end.method_1020(start);
        for (int i = 0; i <= count; ++i) {
            result.add(start.method_1019(diff.method_1021((double)i / (double)count)));
        }
        return result;
    }

    private void damageEntities(class_1937 world, class_1799 stack, class_1657 user, class_243 start, class_243 end) {
        ArrayList entities = new ArrayList();
        List<class_243> increments = this.getIncrements(start, end, 10);
        for (class_243 pos : increments) {
            world.method_8335((class_1297)user, class_238.method_30048((class_243)pos, (double)1.5, (double)1.5, (double)1.5)).forEach(entity -> {
                if (entity instanceof class_1309) {
                    class_1309 living = (class_1309)entity;
                    if (!entities.contains(entity)) {
                        entity.method_5643(MineCellsDamageSource.KATANA.get(world, (class_1297)user), this.getAbilityDamage(stack, (class_1309)user, living));
                        class_243 direction = pos.method_1020(entity.method_19538()).method_1029();
                        ((class_1309)entity).method_6005(0.5, direction.method_10216(), direction.method_10215());
                        entities.add((class_1309)entity);
                    }
                }
            });
        }
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 20;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        user.method_5783(MineCellsSounds.KATANA_CHARGE, 1.0f, 1.0f);
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    @Override
    public ValueCalculator getAbilityDamageCalculator() {
        return ABILITY_DAMAGE_CALCULATOR;
    }

    @Override
    public ValueCalculator getAbilityCooldownCalculator() {
        return ABILITY_COOLDOWN_CALCULATOR;
    }
}

