/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon;

import com.github.mim1q.minecells.entity.nonliving.ShockwavePlacer;
import com.github.mim1q.minecells.item.weapon.interfaces.WeaponWithAbility;
import com.github.mim1q.minecells.item.weapon.melee.CustomMeleeWeapon;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.valuecalculators.ModValueCalculators;
import dev.mim1q.gimm1q.screenshake.ScreenShakeUtils;
import dev.mim1q.gimm1q.valuecalculators.ValueCalculator;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5328;
import net.minecraft.class_638;

public class FlintItem
extends CustomMeleeWeapon
implements WeaponWithAbility {
    private static final ValueCalculator ABILITY_DAMAGE_CALCULATOR = ModValueCalculators.of("melee/the_flint", "ability_damage", 0.0);
    private static final ValueCalculator ABILITY_COOLDOWN_CALCULATOR = ModValueCalculators.of("melee/the_flint", "ability_cooldown", 0.0);

    public FlintItem(class_1792.class_1793 settings) {
        super("the_flint", settings);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        int tick = 72000 - remainingUseTicks;
        if (world.method_8608()) {
            ParticleUtils.addAura((class_638)world, user.method_19538().method_1031(0.0, 1.0, 0.0), (class_2394)class_2398.field_11240, 1, 2.0, -0.1);
            if (tick == 20) {
                user.method_5783(MineCellsSounds.CRIT, 0.5f, 0.9f);
            }
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (world.method_8608()) {
            return;
        }
        int tick = 72000 - remainingUseTicks;
        if (!user.method_31747()) {
            return;
        }
        class_1657 player = (class_1657)user;
        player.method_7357().method_7906((class_1792)this, tick >= 20 ? this.getAbilityCooldown(stack, user) : 20);
        if (tick < 20) {
            return;
        }
        user.method_6092(new class_1293(class_1294.field_5918, 20, 0, false, false, false));
        List.of(Float.valueOf(-3.0f), Float.valueOf(3.0f)).forEach(degOffset -> {
            class_243 offset = MathUtils.vectorRotateY(new class_243(1.0, 0.0, 0.0), MathUtils.radians(user.method_36454() + degOffset.floatValue()));
            ShockwavePlacer placer = ShockwavePlacer.createLine(world, user.method_19538(), user.method_19538().method_1019(offset.method_1021(12.0)), 1.5f, MineCellsBlocks.SHOCKWAVE_FLAME_PLAYER.method_9564(), user.method_5667(), this.getAbilityDamage(stack, null, null));
            world.method_8649((class_1297)placer);
        });
        world.method_8390(class_1309.class, class_238.method_30048((class_243)user.method_19538(), (double)3.0, (double)2.0, (double)3.0), e -> e != user).forEach(entity -> {
            entity.method_5643(world.method_48963().method_48802((class_1657)user), this.getAbilityDamage(stack, user, (class_1309)entity) * 2.0f);
            if (entity.method_5858((class_1297)user) < 4.0) {
                class_243 knockback = user.method_19538().method_1020(entity.method_19538()).method_1029();
                entity.method_6005(0.5, knockback.field_1352, knockback.field_1350);
            }
        });
        class_1268 flintHand = user.method_5998(class_1268.field_5808).method_31574((class_1792)this) ? class_1268.field_5808 : class_1268.field_5810;
        user.method_23667(flintHand, true);
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), MineCellsSounds.FLINT_RELEASE, class_3419.field_15248, 1.0f, 1.0f);
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), MineCellsSounds.HIT_FLOOR, class_3419.field_15248, 1.0f, 1.0f);
        stack.method_7956(2, user, p -> p.method_20236(flintHand));
        ScreenShakeUtils.shakeAround((class_3218)((class_3218)world), (class_243)user.method_19538(), (float)3.0f, (int)20, (double)0.0, (double)5.0, (String)"minecells:weapon_flint");
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        return stack;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), MineCellsSounds.FLINT_CHARGE, class_3419.field_15248, 1.0f, 1.0f);
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    @Override
    public ValueCalculator getAbilityDamageCalculator() {
        return ABILITY_DAMAGE_CALCULATOR;
    }

    @Override
    public ValueCalculator getAbilityCooldownCalculator() {
        return ABILITY_COOLDOWN_CALCULATOR;
    }
}

