/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.nonliving.obelisk;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.data.spawner_runes.SpawnerRuneController;
import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.network.s2c.ObeliskActivationS2CPacket;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_638;

public abstract class ObeliskEntity
extends class_1297 {
    private static final class_4048 HIDDEN_DIMENSIONS = class_4048.method_18384((float)1.75f, (float)0.0f);
    private static final class_2940<Boolean> HIDDEN = class_2945.method_12791(ObeliskEntity.class, (class_2941)class_2943.field_13323);
    private boolean wasHidden = true;
    private int activatedTicks = 1000;
    private int riseTicks = 1000;
    public final AnimationProperty bury = new AnimationProperty(0.0f, MathUtils::easeInOutQuad);
    public final AnimationProperty glow = new AnimationProperty(0.0f, MathUtils::easeInOutQuad);

    public ObeliskEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_23807 = true;
        this.field_5985 = true;
    }

    public abstract class_1792 getActivationItem();

    public abstract class_2960 getSpawnerRuneDataId();

    public abstract class_238 getBox();

    protected abstract void postProcessEntity(class_1297 var1);

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
        ++this.activatedTicks;
        ++this.riseTicks;
    }

    protected void clientTick() {
        this.bury.setupTransitionTo(this.isHidden() ? 50.0f : 0.0f, 40.0f);
        if (this.bury.getProgress() > 0.0f && this.bury.getProgress() < 1.0f) {
            this.spawnRiseParticles();
        }
        this.glow.setupTransitionTo(this.activatedTicks < 100 ? 1.0f : 0.0f, 10.0f);
        if (this.activatedTicks <= 40) {
            this.spawnActivationParticles(this.activatedTicks);
        }
    }

    protected void serverTick() {
        if (this.field_6012 % 20 == 0) {
            boolean hidden = this.isEntityPresent();
            this.setHidden(hidden);
            this.method_18380(hidden ? class_4050.field_18078 : class_4050.field_18076);
            if (hidden != this.wasHidden) {
                this.riseTicks = 0;
            }
            this.wasHidden = hidden;
        }
        if (this.field_6012 % 3 == 0 && this.riseTicks > 10 && this.riseTicks < 49) {
            this.method_5783(class_3417.field_14921, 1.0f, this.field_5974.method_43057() * 0.5f + 0.25f);
            this.method_5783(class_3417.field_14697, 0.3f, this.field_5974.method_43057() * 0.5f + 0.5f);
        }
        if (this.activatedTicks == 40 && !this.isEntityPresent()) {
            List<class_1297> entities = SpawnerRuneController.spawnEntities((class_3218)this.method_37908(), this.getSpawnerRuneDataId(), this.method_24515(), this::postProcessEntity);
            for (class_1297 entity : entities) {
                try {
                    this.postProcessEntity(entity);
                    if (!(entity instanceof MineCellsEntity)) continue;
                    MineCellsEntity mcEntity = (MineCellsEntity)entity;
                    mcEntity.spawnRunePos = this.method_24515();
                }
                catch (ClassCastException e) {
                    MineCells.LOGGER.warn("Failed to post process entity " + String.valueOf(entity) + " by obelisk at pos: " + String.valueOf(this.method_24515()));
                }
            }
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        return pose == class_4050.field_18078 ? HIDDEN_DIMENSIONS : super.method_18377(pose);
    }

    protected void spawnRiseParticles() {
        class_2680 stateBelow = this.method_37908().method_8320(this.method_24515().method_10074());
        ParticleUtils.addInBox((class_638)this.method_37908(), (class_2394)new class_2388(class_2398.field_11217, stateBelow), class_238.method_30048((class_243)this.method_19538(), (double)2.5, (double)0.25, (double)2.0), 50, new class_243(-1.0, 1.0, -1.0));
    }

    public void resetActivatedTicks() {
        this.activatedTicks = 0;
    }

    protected void spawnActivationParticles(int activatedTicks) {
    }

    public class_1269 method_5688(class_1657 user, class_1268 hand) {
        if (this.isHidden() || this.activatedTicks < 100 || this.isEntityPresent()) {
            return class_1269.field_5814;
        }
        class_1799 stack = user.method_5998(hand);
        if (this.getActivationItem() == null || stack.method_31574(this.getActivationItem())) {
            if (!this.method_37908().field_9236) {
                this.method_5783(MineCellsSounds.OBELISK, 1.0f, 1.0f);
                this.activatedTicks = 0;
                if (this.getActivationItem() != null) {
                    stack.method_7939(stack.method_7947() - 1);
                }
                PlayerLookup.tracking((class_1297)this).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)ObeliskActivationS2CPacket.ID, (class_2540)new ObeliskActivationS2CPacket(this.method_5628())));
            }
            return class_1269.field_5812;
        }
        user.method_7353((class_2561)class_2561.method_43469((String)"chat.minecells.obelisk_item_message", (Object[])new Object[]{class_2561.method_43471((String)this.getActivationItem().method_7876())}), true);
        return class_1269.field_5814;
    }

    protected boolean isEntityPresent() {
        for (class_1297 e : this.method_37908().method_8333((class_1297)this, this.getBox(), class_1301.field_6157)) {
            if (!(e instanceof MineCellsEntity)) continue;
            MineCellsEntity mcEntity = (MineCellsEntity)e;
            if (!this.method_24515().equals((Object)mcEntity.spawnRunePos)) continue;
            return true;
        }
        return false;
    }

    public class_1269 method_5664(class_1657 player, class_243 hitPos, class_1268 hand) {
        return this.method_5688(player, hand);
    }

    public boolean method_30948() {
        return !this.isHidden();
    }

    public boolean method_30949(class_1297 other) {
        return !this.isHidden();
    }

    public boolean method_5863() {
        return true;
    }

    protected void method_5693() {
        this.field_6011.method_12784(HIDDEN, (Object)true);
    }

    public void setHidden(boolean hidden) {
        this.field_6011.method_12778(HIDDEN, (Object)hidden);
    }

    public boolean isHidden() {
        return (Boolean)this.field_6011.method_12789(HIDDEN);
    }

    protected void method_5749(class_2487 nbt) {
        this.setHidden(nbt.method_10577("hidden"));
        if (nbt.method_10545("activatedTicks")) {
            this.activatedTicks = nbt.method_10550("activatedTicks");
        }
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10556("hidden", this.isHidden());
        nbt.method_10569("activatedTicks", this.activatedTicks);
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }
}

