/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.nonliving;

import com.github.mim1q.minecells.network.s2c.ShockwaveClientEventS2CPacket;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsEntities;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class ShockwavePlacer
extends class_1297 {
    private static final double STEPS_PER_POS = 2.0;
    private final Map<Integer, Set<class_2338>> positions;
    private int maxAge;
    private class_2680 block;
    @Nullable
    private UUID ownerUuid;
    private float damage;
    private int blockAge;

    private ShockwavePlacer(class_1299<?> type, class_1937 world, Map<Integer, Set<class_2338>> positions, class_2680 block, @Nullable UUID ownerUuid, float damage, int blockAge) {
        super(type, world);
        this.positions = positions;
        this.maxAge = positions.keySet().stream().max(Integer::compareTo).orElse(5);
        this.block = block;
        this.ownerUuid = ownerUuid;
        this.damage = damage;
        this.blockAge = blockAge;
    }

    public ShockwavePlacer(class_1299<?> type, class_1937 world) {
        this(type, world, new HashMap<Integer, Set<class_2338>>(), class_2246.field_10036.method_9564(), null, 0.0f, 20);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            return;
        }
        Set<class_2338> posList = this.positions.get(this.field_6012);
        if (posList != null) {
            for (class_2338 pos : posList) {
                class_2338 placedPos = this.tryPlace(pos);
                if (placedPos == null) continue;
                this.method_37908().method_39279(placedPos, this.block.method_26204(), this.blockAge);
                PlayerLookup.tracking((class_3218)((class_3218)this.method_37908()), (class_2338)placedPos).forEach(player -> ShockwaveClientEventS2CPacket.send(player, this.block.method_26204(), placedPos, false));
                this.damageEntities(placedPos);
            }
        }
        if (this.field_6012 > this.maxAge) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    private class_2338 tryPlace(class_2338 position) {
        class_2338[] positions;
        for (class_2338 pos : positions = new class_2338[]{position, position.method_10084(), position.method_10074()}) {
            if (!this.block.method_26184((class_4538)this.method_37908(), pos)) continue;
            this.method_37908().method_8501(pos, this.block);
            return pos;
        }
        return null;
    }

    private class_238 getDamageBox(class_2338 position) {
        return new class_238(position).method_1009(0.1, 0.0, 0.1).method_989(0.0, -0.25, 0.0);
    }

    private void damageEntities(class_2338 position) {
        boolean isPlayer = this.method_37908().method_18470(this.ownerUuid) != null;
        Predicate<class_1309> predicate = isPlayer ? e -> e.method_5667() != this.ownerUuid : e -> !(e instanceof class_1588);
        List entities = this.method_37908().method_8390(class_1309.class, this.getDamageBox(position), predicate);
        for (class_1309 entity : entities) {
            entity.method_5643(this.method_37908().method_48963().method_48813(), this.damage);
        }
    }

    public boolean method_5640(double distance) {
        return false;
    }

    protected void method_5693() {
    }

    protected void method_5749(class_2487 nbt) {
        class_2487 nbtPositions = nbt.method_10562("positions");
        this.positions.clear();
        for (String k : nbtPositions.method_10541()) {
            long[] v = nbtPositions.method_10565(k);
            this.positions.put(Integer.parseInt(k), Arrays.stream(v).mapToObj(class_2338::method_10092).collect(Collectors.toSet()));
        }
        this.maxAge = nbt.method_10550("maxAge");
        if (nbt.method_10545("block")) {
            class_2487 blockNbt = nbt.method_10562("block");
            this.block = (class_2680)class_2680.field_24734.decode((DynamicOps)class_2509.field_11560, (Object)blockNbt).result().orElse(new Pair((Object)MineCellsBlocks.SHOCKWAVE_FLAME.method_9564(), null)).getFirst();
        }
        if (nbt.method_25928("ownerUuid")) {
            this.ownerUuid = nbt.method_25926("ownerUuid");
        }
        this.damage = nbt.method_10583("damage");
        this.blockAge = nbt.method_10550("blockAge");
    }

    protected void method_5652(class_2487 nbt) {
        class_2487 nbtPositions = new class_2487();
        this.positions.forEach((k, v) -> nbtPositions.method_10538(k.toString(), v.stream().map(class_2338::method_10063).toList()));
        nbt.method_10566("positions", (class_2520)nbtPositions);
        nbt.method_10569("maxAge", this.maxAge);
        class_2680.field_24734.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.block).result().ifPresent(blockNbt -> nbt.method_10566("block", blockNbt));
        if (this.ownerUuid != null) {
            nbt.method_25927("ownerUuid", this.ownerUuid);
        }
        nbt.method_10548("damage", this.damage);
        nbt.method_10548("blockAge", (float)this.blockAge);
    }

    public static ShockwavePlacer createLine(class_1937 world, class_243 startPos, class_243 endPos, float interval, class_2680 block, @Nullable UUID ownerUuid, float damage) {
        HashMap<Integer, Set<class_2338>> map = new HashMap<Integer, Set<class_2338>>();
        class_243 diff = endPos.method_1020(startPos);
        double stepLength = 0.5;
        class_243 step = diff.method_1029().method_1021(stepLength);
        class_243 pos = startPos;
        int accumulatedLength = 0;
        int i = 1;
        while ((double)accumulatedLength <= diff.method_1033() + 2.0) {
            HashSet<class_2338> set = new HashSet<class_2338>();
            int j = 0;
            while ((double)j < 2.0) {
                set.add(class_2338.method_49638((class_2374)pos));
                pos = pos.method_1019(step);
                ++j;
            }
            int index = (int)((float)i * interval);
            if (map.containsKey(index)) {
                map.get(index).addAll(set);
            } else {
                map.put((int)((float)i * interval), set);
            }
            ++accumulatedLength;
            ++i;
        }
        ShockwavePlacer placer = new ShockwavePlacer(MineCellsEntities.SHOCKWAVE_PLACER, world, map, block, ownerUuid, damage, (int)interval + 10);
        placer.method_33574(startPos);
        return placer;
    }

    public static ShockwavePlacer createCircle(class_1937 world, class_243 origin, int radius, float interval, class_2680 block, @Nullable UUID ownerUuid, float damage) {
        HashMap<Integer, Set<class_2338>> map = new HashMap<Integer, Set<class_2338>>();
        for (int i = 1; i < radius; ++i) {
            HashSet<class_2338> set = new HashSet<class_2338>();
            for (int angle = 0; angle < i * 8; ++angle) {
                float x = (float)Math.cos((double)angle * Math.PI / (double)(i * 4)) * (float)i;
                float z = (float)Math.sin((double)angle * Math.PI / (double)(i * 4)) * (float)i;
                set.add(class_2338.method_49638((class_2374)origin).method_10081((class_2382)new class_2338(Math.round(x), 0, Math.round(z))));
            }
            int index = (int)((float)i * interval);
            if (map.containsKey(index)) {
                map.get(index).addAll(set);
                continue;
            }
            map.put((int)((float)i * interval), set);
        }
        ShockwavePlacer placer = new ShockwavePlacer(MineCellsEntities.SHOCKWAVE_PLACER, world, map, block, ownerUuid, damage, (int)interval + 2);
        placer.method_33574(origin);
        return placer;
    }
}

