/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.data.spawner_runes;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.accessor.PlayerEntityAccessor;
import com.github.mim1q.minecells.data.spawner_runes.SpawnerRuneData;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.network.s2c.SpawnRuneParticlesS2CPacket;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.world.state.MineCellsData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class SpawnerRuneController {
    private class_2960 dataId = null;
    private SpawnerRuneData data = null;
    private boolean isVisible = false;
    private long lastActivationTime = 0L;

    public void tick(class_2338 pos, class_1937 world) {
        boolean visible;
        if (!world.field_9236 && this.data != null) {
            float d = this.data.playerDistance();
            for (class_3222 player : world.method_8390(class_3222.class, class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)d, (double)d, (double)d), class_1301.field_6156)) {
                if (!this.canPlayerActivate((class_1657)player, world, pos)) continue;
                MineCellsData.getPlayerData(player, (class_3218)world, null).addActivatedSpawnerRune(MineCellsDimension.of(world), pos);
                MineCellsData.syncCurrentPlayerData(player, (class_3218)world);
                this.spawnEntities(this.data, pos, (class_1657)player);
                break;
            }
        }
        if (world.field_9236 && this.isVisible != (visible = this.canClientPlayerActivate(world, pos))) {
            ParticleUtils.addInBox((class_638)world, MineCellsParticles.SPECKLE.get(16738816), class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)0.5, (double)0.5, (double)0.5), 15, new class_243(-0.2, -0.2, -0.2).method_1021(world.method_8409().method_43058() * 0.5 + 0.5));
            this.isVisible = visible;
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public long getLastActivationTime() {
        return this.lastActivationTime;
    }

    public void setLastActivationTime(long lastActivationTime) {
        this.lastActivationTime = lastActivationTime;
    }

    private void spawnEntities(SpawnerRuneData data, class_2338 pos, class_1657 spawningPlayer) {
        class_1937 world = spawningPlayer.method_37908();
        List<SpawnerRuneData.EntitySpawnData> entities = data.getSelectedEntities(world.method_8409());
        for (SpawnerRuneData.EntitySpawnData entityData : entities) {
            class_1588 hostile;
            class_1297 entity = SpawnerRuneController.spawnEntity((class_3218)world, entityData, SpawnerRuneController.findPos(world, pos, data.spawnDistance()), pos, e -> {});
            if (!(entity instanceof class_1588) || !(hostile = (class_1588)entity).method_6057((class_1297)spawningPlayer)) continue;
            hostile.method_5980((class_1309)spawningPlayer);
        }
        this.lastActivationTime = world.method_8510();
    }

    public static List<class_1297> spawnEntities(class_3218 world, class_2960 dataId, class_2338 pos, Consumer<class_1297> entityConsumer) {
        SpawnerRuneData data = MineCells.SPAWNER_RUNE_DATA.get(dataId);
        if (data == null) {
            return List.of();
        }
        List<SpawnerRuneData.EntitySpawnData> entities = data.getSelectedEntities(world.field_9229);
        ArrayList<class_1297> result = new ArrayList<class_1297>();
        for (SpawnerRuneData.EntitySpawnData entityData : entities) {
            class_1297 entity = SpawnerRuneController.spawnEntity(world, entityData, SpawnerRuneController.findPos((class_1937)world, pos, data.spawnDistance()), pos, entityConsumer);
            result.add(entity);
        }
        return result;
    }

    private boolean canPlayerActivate(class_1657 player, class_1937 world, class_2338 pos) {
        MineCellsData.PlayerData dimensionData = ((PlayerEntityAccessor)player).getCurrentMineCellsPlayerData();
        if (dimensionData == null) {
            return false;
        }
        if (this.data.cooldown() != 0.0f && (float)(world.method_8510() - this.lastActivationTime) < this.data.cooldown() * 20.0f) {
            return false;
        }
        return !dimensionData.hasActivatedSpawnerRune(MineCellsDimension.of(world), pos);
    }

    private boolean canClientPlayerActivate(class_1937 world, class_2338 pos) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        MineCellsData.PlayerData dimensionData = ((PlayerEntityAccessor)player).getCurrentMineCellsPlayerData();
        if (dimensionData == null) {
            return false;
        }
        return !dimensionData.hasActivatedSpawnerRune(MineCellsDimension.of(world), pos);
    }

    private static class_1297 spawnEntity(class_3218 world, SpawnerRuneData.EntitySpawnData entityData, class_2338 pos, class_2338 runePos, Consumer<class_1297> entityConsumer) {
        class_1297 spawnedEntity = entityData.entityType().method_5888(world, null, null, pos, class_3730.field_16459, false, false);
        if (spawnedEntity == null) {
            return null;
        }
        if (spawnedEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)spawnedEntity;
            for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)runePos)) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)SpawnRuneParticlesS2CPacket.ID, (class_2540)new SpawnRuneParticlesS2CPacket(livingEntity.method_5829().method_1014(0.5)));
            }
            entityData.attributeOverrides().forEach((attribute, value) -> {
                class_1324 instance = livingEntity.method_5996(attribute);
                if (instance != null) {
                    instance.method_6192(value.doubleValue());
                }
            });
            class_2487 currentEntityNbt = new class_2487();
            livingEntity.method_5652(currentEntityNbt);
            for (String entry : entityData.nbt().method_10541()) {
                currentEntityNbt.method_10566(entry, entityData.nbt().method_10580(entry));
            }
            livingEntity.method_5749(currentEntityNbt);
            entityConsumer.accept((class_1297)livingEntity);
            livingEntity.method_6025(livingEntity.method_6063());
        }
        world.method_8649(spawnedEntity);
        return spawnedEntity;
    }

    private static class_2338 findPos(class_1937 world, class_2338 pos, float radius) {
        int x = pos.method_10263() + (int)((double)radius * ((double)world.field_9229.method_43057() - 0.5));
        int z = pos.method_10260() + (int)((double)radius * ((double)world.field_9229.method_43057() - 0.5));
        int y = pos.method_10264();
        for (int i = 0; i < 4; ++i) {
            class_2680 state = world.method_8320(new class_2338(x, y, z));
            class_2680 stateBelow = world.method_8320(new class_2338(x, y - 1, z));
            class_2680 stateAbove = world.method_8320(new class_2338(x, y + 1, z));
            boolean solidBelow = stateBelow.method_26206((class_1922)world, new class_2338(x, y - 1, z), class_2350.field_11036);
            boolean empty = state.method_26220((class_1922)world, new class_2338(x, y, z)).method_1110();
            boolean emptyAbove = stateAbove.method_26220((class_1922)world, new class_2338(x, y + 1, z)).method_1110();
            if (solidBelow && empty && emptyAbove) {
                return new class_2338(x, y, z);
            }
            ++y;
        }
        return pos;
    }

    public void setDataId(class_1937 world, class_2338 pos, class_2960 id) {
        SpawnerRuneData newData = MineCells.SPAWNER_RUNE_DATA.get(id);
        this.dataId = id;
        this.data = MineCells.SPAWNER_RUNE_DATA.get(id);
        if (world == null || world.field_9236) {
            return;
        }
        if (newData == null) {
            MineCells.LOGGER.warn("Tried to load unknown spawner rune data with id: " + String.valueOf(id) + " at pos " + pos.method_23854() + " in dimension " + world.method_27983().method_29177().toString());
        }
    }

    public class_2960 getDataId() {
        return this.dataId;
    }
}

