/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render.conjunctivius;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.client.render.model.conjunctivius.ConjunctiviusEntityModel;
import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import com.github.mim1q.minecells.entity.boss.ConjunctiviusEntity;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.RenderUtils;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import org.joml.Vector3f;

public class ConjunctiviusChainRenderer
extends class_3887<ConjunctiviusEntity, ConjunctiviusEntityModel> {
    private static final class_2960 MODEL_ID = MineCells.createId("misc/conjunctivius/chain");
    private static final class_2960 DASH_MODEL_ID = MineCells.createId("misc/conjunctivius/dash_chain");
    private final class_1087 model;
    private final class_1087 dashModel;

    public ConjunctiviusChainRenderer(class_3883<ConjunctiviusEntity, ConjunctiviusEntityModel> context, class_1092 modelManager) {
        super(context);
        this.model = modelManager.getModel(MODEL_ID);
        this.dashModel = modelManager.getModel(DASH_MODEL_ID);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, ConjunctiviusEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_243 target;
        if (entity.isForDisplay()) {
            return;
        }
        class_243 startPos = entity.method_30950(tickDelta);
        class_4588 vertices = vertexConsumers.getBuffer(class_1921.method_23581());
        int stage = entity.getStage();
        if (stage < 2) {
            this.renderChain(entity, matrices, vertices, startPos, class_243.method_24955((class_2382)entity.getRightAnchor()), entity.method_36454(), new Vector3f(2.2f, 0.85f, 0.0f), false);
        }
        if (stage < 4) {
            this.renderChain(entity, matrices, vertices, startPos, class_243.method_24955((class_2382)entity.getLeftAnchor()), entity.method_36454(), new Vector3f(-2.2f, 0.85f, 0.0f), false);
        }
        if (stage < 6) {
            this.renderChain(entity, matrices, vertices, startPos, class_243.method_24955((class_2382)entity.getTopAnchor().method_10084()), entity.method_36454(), new Vector3f(0.0f, -1.75f, 0.0f), false);
        }
        class_4588 dashVertices = vertexConsumers.getBuffer(class_1921.method_23583());
        if (entity.getDashState() == TimedActionGoal.State.CHARGE && !(target = entity.getDashTarget()).equals((Object)class_243.field_1353)) {
            this.renderChain(entity, matrices, dashVertices, startPos, target, entity.method_36454(), new Vector3f(0.0f, 0.0f, 0.0f), true);
        }
    }

    protected void renderChain(ConjunctiviusEntity entity, class_4587 matrices, class_4588 vertices, class_243 startPos, class_243 targetPos, float headYaw, Vector3f offset, boolean isDash) {
        class_1087 modelToUse = isDash ? this.dashModel : this.model;
        matrices.method_22903();
        matrices.method_22905(0.75f, 0.75f, 0.75f);
        startPos = startPos.method_1031(0.0, (double)(-offset.y) * 2.0 + 3.0, 0.01 - (double)offset.z * 1.5);
        class_243 direction = targetPos.method_1020(startPos);
        class_243 normDir = direction.method_1029().method_1021(0.75);
        direction = direction.method_1024(MathUtils.radians(headYaw));
        direction = direction.method_1031((double)(-offset.x) * 1.5, 0.0, 0.0);
        float rx = (float)(-Math.atan2(direction.field_1351, Math.sqrt(direction.field_1352 * direction.field_1352 + direction.field_1350 * direction.field_1350)));
        float ry = (float)(-Math.atan2(direction.field_1352, direction.field_1350));
        MathUtils.PosRotScale posRotScale = MathUtils.PosRotScale.ofRadians(offset, new Vector3f(rx, ry, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        posRotScale.apply(matrices);
        int count = (int)direction.method_1033();
        matrices.method_22904(-0.5, -0.5, -1.25);
        class_243 lightPos = startPos.method_1031((double)(-offset.x) * 1.5, 0.0, (double)offset.z);
        int light = 0xF000F0;
        for (int i = 0; i < count; ++i) {
            if (!isDash) {
                int lightLevel = entity.method_37908().method_22339(class_2338.method_49638((class_2374)lightPos));
                light = class_765.method_23687((int)lightLevel, (int)lightLevel);
                lightPos = lightPos.method_1019(normDir);
            }
            RenderUtils.renderBakedModel(modelToUse, entity.method_6051(), light, matrices, vertices);
            matrices.method_46416(0.0f, 0.0f, -1.0f);
        }
        matrices.method_22909();
    }
}

