/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render.blockentity;

import com.github.mim1q.minecells.block.FlagBlock;
import com.github.mim1q.minecells.block.blockentity.FlagBlockEntity;
import com.github.mim1q.minecells.registry.MineCellsRenderers;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.RenderUtils;
import java.util.ArrayList;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_827;
import org.joml.Math;
import org.joml.Quaternionf;

public class FlagBlockEntityRenderer
implements class_827<FlagBlockEntity> {
    private final BiomeBannerBlockEntityModel model;
    private final BiomeBannerBlockEntityModel largeModel;

    public FlagBlockEntityRenderer(class_5614.class_5615 ctx) {
        class_5599 loader = ctx.method_32142();
        this.model = new BiomeBannerBlockEntityModel(loader.method_32072(MineCellsRenderers.FLAG_LAYER));
        this.largeModel = new BiomeBannerBlockEntityModel(loader.method_32072(MineCellsRenderers.FLAG_LARGE_LAYER));
    }

    public int method_33893() {
        return 256;
    }

    public void render(FlagBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2248 block = entity.method_11010().method_26204();
        if (!(block instanceof FlagBlock)) {
            return;
        }
        class_2350 dir = (class_2350)entity.method_11010().method_11654((class_2769)FlagBlock.FACING);
        FlagBlock.Placement placement = (FlagBlock.Placement)((Object)entity.method_11010().method_11654(FlagBlock.PLACEMENT));
        class_1937 world = entity.method_10997();
        int timeOffset = entity.method_11016().hashCode();
        class_243 offset = entity.method_11010().method_26226((class_1922)world, entity.method_11016());
        boolean large = ((FlagBlock)block).large;
        BiomeBannerBlockEntityModel usedModel = large ? this.largeModel : this.model;
        float strength = (placement == FlagBlock.Placement.HORIZONTAL ? 0.2f : 0.125f) * (large ? 0.3f : 1.0f);
        if (world != null && ((Boolean)entity.method_11010().method_11654((class_2769)FlagBlock.WAVING)).booleanValue()) {
            float time = RenderUtils.getGlobalAnimationProgress();
            usedModel.wave(time * (large ? 0.15f : 0.1f), timeOffset % 100, strength * (1.0f + 0.15f * Math.cos((float)(time * 0.13f))), true);
        } else {
            usedModel.resetSegments();
        }
        matrices.method_22903();
        float offsetZ = 0.0f;
        matrices.method_22904(offset.method_10216(), offset.method_10214(), offset.method_10215());
        switch (placement) {
            case SIDE: {
                offsetZ = 0.4375f;
            }
            case CENTERED: {
                matrices.method_46416(0.5f, 0.9375f, 0.5f);
                matrices.method_22905(1.0f, -1.0f, -1.0f);
                matrices.method_22907(new Quaternionf().rotationY(MathUtils.radians(dir.method_10144())));
                matrices.method_46416(0.0f, 0.0f, offsetZ);
                break;
            }
            case HORIZONTAL: {
                matrices.method_46416(0.5f, 0.5f, 0.5f);
                matrices.method_22905(1.0f, -1.0f, -1.0f);
                matrices.method_22907(new Quaternionf().rotationZ(MathUtils.radians(90.0f)));
                matrices.method_22907(new Quaternionf().rotationX(MathUtils.radians(-90.0f + dir.method_10144())));
                matrices.method_46416(0.0f, -0.8125f, 0.0f);
            }
        }
        class_2960 texture = ((FlagBlock)block).texture;
        usedModel.method_2828(matrices, vertexConsumers.getBuffer(usedModel.method_23500(texture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.method_22909();
    }

    public boolean rendersOutsideBoundingBox(FlagBlockEntity blockEntity) {
        return true;
    }

    public static class BiomeBannerBlockEntityModel
    extends class_3879 {
        private final class_630 main;
        private final class_630[] segments;

        public BiomeBannerBlockEntityModel(class_630 root) {
            super(class_1921::method_23576);
            this.main = root.method_32086("main");
            ArrayList<class_630> segments = new ArrayList<class_630>();
            class_630 parent = this.main;
            int i = 0;
            while (parent.method_41919("segment" + i)) {
                segments.add(parent.method_32086("segment" + i));
                parent = (class_630)segments.get(i);
                ++i;
            }
            this.segments = segments.toArray(new class_630[0]);
        }

        public static class_5607 getTexturedModelData(boolean large) {
            class_5609 modelData = new class_5609();
            class_5610 modelPartData = modelData.method_32111();
            int width = large ? 24 : 16;
            int height = 8;
            int segmentCount = large ? 14 : 6;
            class_5610[] segmentDatas = new class_5610[segmentCount];
            class_5610 dMain = modelPartData.method_32117("main", class_5606.method_32108().method_32101(0, 0).method_32097((float)(-width) / 2.0f, -1.0f, -1.0f, (float)width, 2.0f, 2.0f), class_5603.field_27701);
            for (int i = 0; i < segmentCount; ++i) {
                class_5610 parent = i == 0 ? dMain : segmentDatas[i - 1];
                segmentDatas[i] = parent.method_32117("segment" + i, class_5606.method_32108().method_32101(0, 16 + i * height).method_32097((float)(-width) / 2.0f, 0.0f, 0.0f, (float)width, (float)height, 0.0f), class_5603.method_32090((float)0.0f, (float)(i == 0 ? 0.0f : (float)height), (float)0.0f));
            }
            return class_5607.method_32110((class_5609)modelData, (int)64, (int)(large ? 128 : 64));
        }

        public void setupLargeItemModel() {
            for (int i = 5; i < this.segments.length; ++i) {
                this.segments[i].field_38456 = true;
            }
        }

        public void wave(float animationProgress, float offset, float strength, boolean tapered) {
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i].field_3654 = Math.sin((float)(animationProgress - (float)i + offset)) * strength * (tapered ? (float)i : 1.0f);
            }
        }

        public void resetSegments() {
            for (class_630 part : this.segments) {
                part.field_3654 = 0.0f;
                part.field_38456 = false;
            }
        }

        public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
            this.main.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }
}

