/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.config.MineCellsClientConfig;
import com.github.mim1q.minecells.item.weapon.bow.CustomArrowShooter;
import com.github.mim1q.minecells.item.weapon.bow.CustomArrowType;
import com.github.mim1q.minecells.item.weapon.bow.LightningBoltItem;
import com.github.mim1q.minecells.item.weapon.interfaces.CritIndicator;
import com.github.mim1q.minecells.item.weapon.interfaces.CrittingWeapon;
import com.github.mim1q.minecells.item.weapon.interfaces.WeaponWithAbility;
import com.github.mim1q.minecells.item.weapon.melee.CustomMeleeWeapon;
import com.github.mim1q.minecells.item.weapon.shield.CustomShieldItem;
import com.github.mim1q.minecells.item.weapon.shield.CustomShieldType;
import com.github.mim1q.minecells.network.ClientPacketHandler;
import com.github.mim1q.minecells.registry.MineCellsItemGroups;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsRenderers;
import com.google.common.collect.Streams;
import dev.mim1q.gimm1q.client.highlight.HighlightDrawerCallback;
import dev.mim1q.gimm1q.client.highlight.crosshair.CrosshairTipDrawerCallback;
import dev.mim1q.gimm1q.client.item.handheld.HandheldItemModelRegistry;
import dev.mim1q.gimm1q.client.tooltip.TooltipResolverRegistry;
import dev.mim1q.gimm1q.screenshake.ScreenShakeModifiers;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorContext;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorParameter;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class MineCellsClient
implements ClientModInitializer {
    private static final class_2960 CRIT_CROSSHAIR = MineCells.createId("textures/gui/crosshair/crit_indicator.png");
    public static final MineCellsClientConfig CLIENT_CONFIG = MineCellsClientConfig.createAndLoad();

    public void onInitializeClient() {
        CLIENT_CONFIG.save();
        MineCellsRenderers.init();
        MineCellsRenderers.initBlocks();
        MineCellsItemGroups.init();
        ClientPacketHandler.init();
        MineCellsParticles.initClient();
        if (CLIENT_CONFIG.keepOriginalGuiModels()) {
            this.setupAllHandheldModels();
        }
        this.setupShieldHandheldModels();
        if (CLIENT_CONFIG.showCritIndicator()) {
            this.setupCritIndicator();
        }
        this.loadArrowModels();
        this.loadMiscCustomModels();
        this.setupTentacleWeaponHighlighting();
        this.setupLightningBoltHighlighting();
        this.setupTooltips();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> MineCellsClient.setupScreenShakeModifiers(MineCellsClient.CLIENT_CONFIG.screenShake().global));
        FabricLoader.getInstance().getModContainer("minecells").ifPresent(modContainer -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)MineCells.createId("ribcages"), (ModContainer)modContainer, (class_2561)class_2561.method_43470((String)"[Mine Cells]").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" Ribcages").method_10862(class_2583.field_24360.method_10977(class_124.field_1065))), (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
    }

    private void setupTooltips() {
        TooltipResolverRegistry.getInstance().register((ctx, helper) -> {
            class_1792 patt1$temp;
            CrittingWeapon crittingWeapon;
            float critDamage;
            helper.defaultStyle(class_2583.field_24360.method_10977(class_124.field_1063));
            class_1799 item = ctx.item();
            String tooltip = item.method_7909().method_7866(item) + ".description";
            class_5250 description = class_2561.method_48321((String)tooltip, (String)"");
            if (!description.getString().isBlank()) {
                helper.maxLineWidth(40);
                helper.addLine((class_2561)description);
            }
            class_2583 specialStyle = class_2583.field_24360.method_10977(class_124.field_1065);
            boolean doesCrit = false;
            class_1792 patt0$temp = item.method_7909();
            if (patt0$temp instanceof CrittingWeapon && (critDamage = (crittingWeapon = (CrittingWeapon)patt0$temp).getAdditionalCritDamage(item, null, (class_1309)ctx.player())) > 0.0f) {
                doesCrit = true;
                helper.addLine((class_2561)class_2561.method_43469((String)"item.minecells.crit_damage", (Object[])new Object[]{Float.valueOf(critDamage)}).method_10862(specialStyle));
            }
            if ((patt1$temp = item.method_7909()) instanceof WeaponWithAbility) {
                WeaponWithAbility weaponWithAbility = (WeaponWithAbility)patt1$temp;
                if (doesCrit) {
                    helper.addLine((class_2561)class_2561.method_43473());
                }
                float damage = weaponWithAbility.getAbilityDamage(item, (class_1309)ctx.player(), null);
                double cooldown = (double)weaponWithAbility.getAbilityCooldown(item, (class_1309)ctx.player()) / 20.0;
                helper.addLine((class_2561)class_2561.method_43469((String)"item.minecells.special_ability_hold", (Object[])new Object[]{Float.valueOf(damage), cooldown}).method_10862(specialStyle));
            }
        }, (class_1792[])Streams.concat((Stream[])new Stream[]{CustomMeleeWeapon.getAllMeleeWeapons().stream(), Stream.of(MineCellsItems.FROST_BLAST, MineCellsItems.LIGHTNING_BOLT, MineCellsItems.ELECTRIC_WHIP, MineCellsItems.PHASER)}).toArray(class_1792[]::new));
        TooltipResolverRegistry.getInstance().register((ctx, helper) -> {
            helper.defaultStyle(class_2583.field_24360.method_10977(class_124.field_1063));
            class_1799 item = ctx.item();
            String tooltip = item.method_7909().method_7866(item) + ".description";
            class_5250 description = class_2561.method_48321((String)tooltip, (String)"");
            if (!description.getString().isBlank()) {
                helper.maxLineWidth(40);
                helper.addLine((class_2561)description);
            }
            class_2583 specialStyle = class_2583.field_24360.method_10977(class_124.field_1065);
            class_1792 patt0$temp = item.method_7909();
            if (patt0$temp instanceof CustomArrowShooter) {
                CustomArrowShooter arrowShooter = (CustomArrowShooter)patt0$temp;
                CustomArrowType type = arrowShooter.getArrowType();
                ValueCalculatorContext context = ValueCalculatorContext.create().with(ValueCalculatorParameter.HOLDER, (Object)ctx.player()).with(ValueCalculatorParameter.HOLDER_STACK, (Object)ctx.item());
                double drawTime = (double)type.getDrawTime(context) / 20.0;
                double cooldown = (double)type.getCooldown(context) / 20.0;
                float damage = type.getDamage(context);
                float critDamage = type.getAdditionalCritDamage(context);
                if (damage > 0.0f) {
                    helper.addLine((class_2561)class_2561.method_43469((String)"item.minecells.bow.damage", (Object[])new Object[]{Float.valueOf(damage)}).method_10862(specialStyle));
                }
                if (critDamage > 0.0f) {
                    helper.addLine((class_2561)class_2561.method_43469((String)"item.minecells.bow.crit_damage", (Object[])new Object[]{Float.valueOf(critDamage)}).method_10862(specialStyle));
                }
                if (drawTime > 0.0) {
                    helper.addLine((class_2561)class_2561.method_43469((String)"item.minecells.bow.draw_time", (Object[])new Object[]{drawTime}).method_10862(specialStyle));
                }
                if (cooldown > 0.0) {
                    helper.addLine((class_2561)class_2561.method_43469((String)"item.minecells.bow.cooldown", (Object[])new Object[]{cooldown}).method_10862(specialStyle));
                }
            }
        }, (class_1792[])Streams.concat((Stream[])new Stream[]{MineCellsItems.BOWS.stream(), MineCellsItems.CROSSBOWS.stream(), Stream.of(MineCellsItems.FIREBRANDS, MineCellsItems.THROWING_KNIFE)}).toArray(class_1792[]::new));
        TooltipResolverRegistry.getInstance().register((ctx, helper) -> {
            helper.defaultStyle(class_2583.field_24360.method_10977(class_124.field_1063));
            class_1799 item = ctx.item();
            String tooltip = item.method_7909().method_7866(item) + ".description";
            class_5250 description = class_2561.method_48321((String)tooltip, (String)"");
            if (!description.getString().isBlank()) {
                helper.maxLineWidth(40);
                helper.addLine((class_2561)description);
            }
            class_2583 specialStyle = class_2583.field_24360.method_10977(class_124.field_1065);
            class_1792 patt0$temp = item.method_7909();
            if (patt0$temp instanceof CustomShieldItem) {
                CustomShieldItem shieldItem = (CustomShieldItem)patt0$temp;
                ValueCalculatorContext context = ValueCalculatorContext.create().with(ValueCalculatorParameter.HOLDER, (Object)ctx.player()).with(ValueCalculatorParameter.HOLDER_STACK, (Object)ctx.item());
                CustomShieldType type = shieldItem.shieldType;
                float parryDamage = type.getParryDamage(context);
                float damageReduction = type.getBlockDamageReduction(context);
                double cooldown = (double)type.getCooldown(context, false) / 20.0;
                if (parryDamage > 0.0f) {
                    helper.addLine((class_2561)class_2561.method_43469((String)"item.minecells.shield.parry_damage", (Object[])new Object[]{Float.valueOf(parryDamage)}).method_10862(specialStyle));
                }
                if (damageReduction > 0.0f) {
                    helper.addLine((class_2561)class_2561.method_43469((String)"item.minecells.shield.damage_reduction", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", (double)damageReduction * 100.0)}).method_10862(specialStyle));
                }
                if (cooldown > 0.0) {
                    helper.addLine((class_2561)class_2561.method_43469((String)"item.minecells.shield.cooldown", (Object[])new Object[]{cooldown}).method_10862(specialStyle));
                }
            }
        }, (class_1792[])MineCellsItems.SHIELDS.toArray(class_1792[]::new));
    }

    private void loadMiscCustomModels() {
        ModelLoadingPlugin.register(context -> {
            List<class_2960> miscModels = Stream.of("conjunctivius/chain", "conjunctivius/dash_chain").map(it -> MineCells.createId("misc/" + it)).toList();
            context.addModels(miscModels);
        });
    }

    private void setupTentacleWeaponHighlighting() {
        HighlightDrawerCallback.EVENT.register((drawer, ctx) -> {
            class_1799 stack = ctx.player().method_6047();
            if (stack.method_31574((class_1792)MineCellsItems.TENTACLE)) {
                class_239 hitResult = MineCellsItems.TENTACLE.hitResult;
                if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
                    return;
                }
                if (hitResult.method_17783() == class_239.class_240.field_1331) {
                    drawer.highlightEntity(((class_3966)hitResult).method_17782(), 0, -5626389);
                    return;
                }
                drawer.highlightBlock(((class_3965)hitResult).method_17777(), 0, -5626389);
            }
        });
    }

    private void setupLightningBoltHighlighting() {
        HighlightDrawerCallback.EVENT.register((drawer, ctx) -> {
            class_1309 entity;
            class_1799 stack = ctx.player().method_6047();
            if (stack.method_31574(MineCellsItems.LIGHTNING_BOLT) && (entity = LightningBoltItem.getTargetedEntity(stack, ctx.player().method_37908())) != null) {
                int ticks = ctx.player().method_6048();
                int color = 0xFF000000 | LightningBoltItem.getLightningColor(ticks);
                drawer.highlightEntity((class_1297)entity, 0, color);
            }
        });
    }

    private void setupCritIndicator() {
        CrosshairTipDrawerCallback.register((drawer, ctx) -> {
            class_1799 stack = ctx.player().method_6047();
            class_1792 patt0$temp = stack.method_7909();
            if (patt0$temp instanceof CritIndicator) {
                class_3966 entityHitResult;
                class_1297 patt1$temp;
                CritIndicator item = (CritIndicator)patt0$temp;
                class_239 hitResult = class_310.method_1551().field_1765;
                class_1309 entity = null;
                if (hitResult instanceof class_3966 && (patt1$temp = (entityHitResult = (class_3966)hitResult).method_17782()) instanceof class_1309) {
                    class_1309 livingEntity;
                    entity = livingEntity = (class_1309)patt1$temp;
                }
                if (item.shouldShowCritIndicator(ctx.player(), entity, stack)) {
                    drawer.drawCrosshairTip(12, 0, 16, CRIT_CROSSHAIR);
                }
            }
        });
    }

    public static void setupScreenShakeModifiers(float d) {
        ScreenShakeModifiers.setModifier((String)"minecells:weapon_flint", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().weaponFlint));
        ScreenShakeModifiers.setModifier((String)"minecells:weapon_lightning_bolt", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().weaponLightningBolt));
        ScreenShakeModifiers.setModifier((String)"minecells:shield_block", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().shieldBlock));
        ScreenShakeModifiers.setModifier((String)"minecells:shield_parry", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().shieldParry));
        ScreenShakeModifiers.setModifier((String)"minecells:conjunctivius_smash", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().conjunctiviusSmash));
        ScreenShakeModifiers.setModifier((String)"minecells:conjunctivius_roar", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().conjunctiviusRoar));
        ScreenShakeModifiers.setModifier((String)"minecells:conjunctivius_death", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().conjunctiviusDeath));
        ScreenShakeModifiers.setModifier((String)"minecells:concierge_leap", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().conciergeLeap));
        ScreenShakeModifiers.setModifier((String)"minecells:concierge_step", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().conciergeStep));
        ScreenShakeModifiers.setModifier((String)"minecells:concierge_roar", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().conciergeRoar));
        ScreenShakeModifiers.setModifier((String)"minecells:concierge_death", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().conciergeDeath));
        ScreenShakeModifiers.setModifier((String)"minecells:explosion", (float)(d * MineCellsClient.CLIENT_CONFIG.screenShake().explosion));
    }

    private void setupAllHandheldModels() {
        this.setupHandheldModel(MineCellsItems.ASSASSINS_DAGGER);
        this.setupHandheldModel(MineCellsItems.BROADSWORD);
        this.setupHandheldModel(MineCellsItems.BALANCED_BLADE);
        this.setupHandheldModel(MineCellsItems.BLOOD_SWORD);
        this.setupHandheldModel(MineCellsItems.CROWBAR);
        this.setupHandheldModel(MineCellsItems.FLINT);
        this.setupHandheldModel(MineCellsItems.HATTORIS_KATANA);
        this.setupHandheldModel(MineCellsItems.SPITE_SWORD);
        this.setupHandheldModel(MineCellsItems.CURSED_SWORD);
        this.setupHandheldModel(MineCellsItems.PHASER);
        this.setupHandheldModel(MineCellsItems.FROST_BLAST);
        this.setupHandheldModel(MineCellsItems.NUTCRACKER);
        this.setupHandheldModel((class_1792)MineCellsItems.TENTACLE);
    }

    private void setupHandheldModel(class_1792 weapon) {
        String name = class_7923.field_41178.method_10221((Object)weapon).method_12832();
        HandheldItemModelRegistry.getInstance().register(weapon, MineCells.createId("weapon/" + name), MineCells.createId(name));
    }

    private void setupShieldHandheldModels() {
        for (class_1792 shield : MineCellsItems.SHIELDS) {
            String name = class_7923.field_41178.method_10221((Object)shield).method_12832();
            HandheldItemModelRegistry.getInstance().register(shield, MineCells.createId(name), MineCells.createId("shield_3d/" + name));
        }
    }

    private void loadArrowModels() {
        ModelLoadingPlugin.register(context -> context.addModels(CustomArrowType.getAllNames().stream().map(it -> MineCells.createId("arrow/" + it)).toList()));
    }
}

