/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.mixin.common.minecolonies;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.entity.ai.workers.util.Tree;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steve_gall.minecolonies_tweaks.core.common.block.ChrousTree;

@Mixin(value={Tree.class}, remap=false)
public abstract class TreeMixin {
    @Shadow(remap=false)
    LinkedList<BlockPos> woodBlocks;
    @Shadow(remap=false)
    BlockPos location;
    @Shadow(remap=false)
    BlockPos topLog;

    @Shadow(remap=false)
    abstract void addAndSearch(@NotNull Level var1, @NotNull BlockPos var2, @Nullable IColony var3);

    @Inject(method={"addAndSearch"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void addAndSearch(Level level, BlockPos log, IColony colony, CallbackInfo ci) {
        BlockState state = level.m_8055_(log);
        if (state.m_60713_(Blocks.f_50490_) || state.m_60713_(Blocks.f_50491_)) {
            ChrousTree chrousTree = new ChrousTree((LevelReader)level, log);
            this.woodBlocks.addAll(chrousTree.getDeadFlowers());
            this.woodBlocks.add(chrousTree.getLog());
            this.location = chrousTree.getLog();
            this.topLog = chrousTree.getLog();
            ci.cancel();
        }
    }

    @Inject(method={"calcSapling"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private void calcSapling(Level world, CallbackInfoReturnable<ItemStack> cir) {
        BlockState state = world.m_8055_(this.topLog);
        if (state.m_60713_(Blocks.f_50490_) || state.m_60713_(Blocks.f_50491_)) {
            cir.setReturnValue((Object)new ItemStack((ItemLike)Items.f_42003_));
        }
    }

    @Inject(method={"checkTree"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private static void checkTree(LevelReader level, BlockPos pos, List<ItemStorage> treesToNotCut, int dyntreesize, CallbackInfoReturnable<Boolean> cir) {
        ItemStack chorusSapling = new ItemStack((ItemLike)Blocks.f_50491_);
        for (ItemStorage stack : treesToNotCut) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)chorusSapling, (ItemStack)stack.getItemStack()).booleanValue()) continue;
            return;
        }
        ChrousTree chrousTree = new ChrousTree(level, pos);
        if (chrousTree.isChorusTree() && chrousTree.getAliveFlowers().size() == 0) {
            cir.setReturnValue((Object)true);
        }
    }
}

