/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.research;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchBranch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.CustomizableRequestable;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IRequestableObject;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public class ResearchCost
implements IRequestableObject {
    public static final ResourceLocation ID = MineColoniesTweaks.rl("research_cost");
    public static final Component DISPLAY_STRING = Component.m_237115_((String)"minecolonies_tweaks.text.research_cost");
    public static final ResourceLocation ICON = new ResourceLocation("textures/item/book.png");
    private final ResourceLocation branchId;
    private final ResourceLocation researchId;
    private final List<ItemStorage> items;
    private final UUID requester;
    private final Component longText;
    private final List<MutableComponent> tooltip;

    public static ResearchCost deserialize(IFactoryController controller, CompoundTag compound) {
        ResourceLocation branch = new ResourceLocation(compound.m_128461_("branch"));
        ResourceLocation research = new ResourceLocation(compound.m_128461_("research"));
        ListTag stacksTag = compound.m_128437_("stacks", 10);
        List<ItemStorage> items = compound.m_128451_("version") == 0 ? NBTUtils.streamCompound((ListTag)stacksTag).map(ItemStack::m_41712_).map(ItemStorage::new).toList() : NBTUtils.streamCompound((ListTag)stacksTag).map(arg_0 -> ((StandardFactoryController)StandardFactoryController.getInstance()).deserialize(arg_0)).toList();
        UUID requester = compound.m_128403_("requester") ? compound.m_128342_("requester") : null;
        return new ResearchCost(branch, research, items, requester);
    }

    public static void serialize(IFactoryController controller, CompoundTag compound, ResearchCost cost) {
        compound.m_128405_("version", 1);
        compound.m_128359_("branch", cost.branchId.toString());
        compound.m_128359_("research", cost.researchId.toString());
        compound.m_128365_("stacks", (Tag)cost.items.stream().map(arg_0 -> ((StandardFactoryController)StandardFactoryController.getInstance()).serialize(arg_0)).collect(NBTUtils.toListNBT()));
        if (cost.requester != null) {
            compound.m_128362_("requester", cost.requester);
        }
    }

    public static boolean test(IRequest<?> request, ResourceLocation branch, ResourceLocation research) {
        ResearchCost other;
        CustomizableRequestable cr;
        Object object = request.getRequest();
        return object instanceof CustomizableRequestable && (object = (cr = (CustomizableRequestable)object).getObject()) instanceof ResearchCost && (other = (ResearchCost)object).getBranchId().equals((Object)branch) && other.getResearchId().equals((Object)research);
    }

    public static boolean isRequested(IBuilding building, ResourceLocation branch, ResourceLocation research) {
        for (IToken token : (Collection)building.getOpenRequestsByRequestableType().getOrDefault(CustomizableRequestable.TYPE_TOKEN, Collections.emptyList())) {
            IRequest request = building.getColony().getRequestManager().getRequestForToken(token);
            if (!ResearchCost.test(request, branch, research)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRequested(IBuildingView buildingView, ResourceLocation branch, ResourceLocation research) {
        for (IRequest request : buildingView.getOpenRequestsOfBuilding()) {
            if (!ResearchCost.test(request, branch, research)) continue;
            return true;
        }
        return false;
    }

    public ResearchCost(ResourceLocation branchId, ResourceLocation researchId, List<ItemStorage> items, UUID requester) {
        this.branchId = branchId;
        this.researchId = researchId;
        this.items = ImmutableList.copyOf(items);
        this.requester = requester;
        IGlobalResearchTree researchTree = IGlobalResearchTree.getInstance();
        IGlobalResearchBranch branch = researchTree.getBranchData(branchId);
        MutableComponent branchText = Component.m_237113_((String)branchId.toString());
        MutableComponent researchText = Component.m_237113_((String)researchId.toString());
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        tooltip.add(Component.m_237119_().m_7220_(DISPLAY_STRING));
        if (branch == null) {
            tooltip.add(Component.m_237115_((String)"minecolonies_tweaks.gui.branch_missing").m_130940_(ChatFormatting.RED));
            tooltip.add(Component.m_237110_((String)"minecolonies_tweaks.text.research_cost.branch", (Object[])new Object[]{Component.m_237113_((String)branchId.toString()).m_130940_(ChatFormatting.RED)}));
            tooltip.add(Component.m_237110_((String)"minecolonies_tweaks.text.research_cost.research", (Object[])new Object[]{Component.m_237113_((String)researchId.toString()).m_130940_(ChatFormatting.RED)}));
        } else {
            IGlobalResearch research = researchTree.getResearch(branchId, researchId);
            branchText = MutableComponent.m_237204_((ComponentContents)branch.getName());
            tooltip.add(Component.m_237110_((String)"minecolonies_tweaks.text.research_cost.branch", (Object[])new Object[]{branchText}));
            if (research == null) {
                tooltip.add(Component.m_237115_((String)"minecolonies_tweaks.gui.research_missing").m_130940_(ChatFormatting.RED));
                tooltip.add(Component.m_237110_((String)"minecolonies_tweaks.text.research_cost.research", (Object[])new Object[]{Component.m_237113_((String)researchId.toString()).m_130940_(ChatFormatting.RED)}));
            } else {
                researchText = MutableComponent.m_237204_((ComponentContents)research.getName());
                tooltip.add(Component.m_237110_((String)"minecolonies_tweaks.text.research_cost.research", (Object[])new Object[]{researchText}));
            }
        }
        this.longText = Component.m_237110_((String)"minecolonies_tweaks.text.research_cost.long", (Object[])new Object[]{branchText, researchText});
        this.tooltip = tooltip;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @NotNull
    public Component getShortDisplayString() {
        return DISPLAY_STRING;
    }

    @Override
    @NotNull
    public Component getLongDisplayString() {
        return this.longText;
    }

    @Override
    @NotNull
    public List<ItemStack> getDisplayStacks() {
        return Collections.emptyList();
    }

    @Override
    public ResourceLocation getDisplayIcon() {
        return ICON;
    }

    @Override
    @NotNull
    public List<MutableComponent> getResolverToolTip(@NotNull IColonyView colony) {
        return this.tooltip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ResearchCost)) return false;
        ResearchCost other = (ResearchCost)obj;
        if (!other.branchId.equals((Object)this.branchId)) return false;
        if (!other.researchId.equals((Object)this.researchId)) return false;
        return true;
    }

    public ResourceLocation getBranchId() {
        return this.branchId;
    }

    public ResourceLocation getResearchId() {
        return this.researchId;
    }

    public List<ItemStorage> getItems() {
        return this.items;
    }

    public UUID getRequester() {
        return this.requester;
    }
}

