/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.network.message;

import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import java.util.Collection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModule;
import steve_gall.minecolonies_tweaks.api.common.building.module.IIdListModuleView;
import steve_gall.minecolonies_tweaks.core.common.network.message.BuildingModuleMessage;

public class AssignIdListMessage
extends BuildingModuleMessage {
    private final Function function;
    private final Collection<ResourceLocation> ids;

    public AssignIdListMessage(IIdListModuleView module, Function function, Collection<ResourceLocation> ids) {
        super(module);
        this.function = function;
        this.ids = ids.stream().toList();
    }

    public AssignIdListMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this.function = (Function)buffer.m_130066_(Function.class);
        this.ids = buffer.m_236845_(FriendlyByteBuf::m_130281_);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130068_((Enum)this.function);
        buffer.m_236828_(this.ids, FriendlyByteBuf::m_130085_);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        super.handle(context);
        IBuildingModule iBuildingModule = this.getModulePos().getModule();
        if (iBuildingModule instanceof IIdListModule) {
            IIdListModule module = (IIdListModule)iBuildingModule;
            if (this.function == Function.CLEAR) {
                module.clearIds();
            } else if (this.function == Function.ADD) {
                module.addIds(this.ids);
            } else if (this.function == Function.REMOVE) {
                module.removeIds(this.ids);
            }
        }
    }

    public Function getFunction() {
        return this.function;
    }

    public Collection<ResourceLocation> getIds() {
        return this.ids;
    }

    public static enum Function {
        CLEAR,
        ADD,
        REMOVE;

    }
}

