/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.building.module;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;
import steve_gall.minecolonies_tweaks.core.common.config.MCTweaksConfigCommon;
import steve_gall.minecolonies_tweaks.core.common.util.GsonHelper2;

public class CustomCraftingModule
extends AbstractCraftingBuildingModule.Custom {
    private final String name;
    private final boolean forceVisible;

    public static void loadCustomCraftingModules() {
        try {
            Gson gson = new Gson();
            for (String raw : (List)MCTweaksConfigCommon.INSTANCE.buildings.customCraftingModules.get()) {
                try {
                    JsonObject json = (JsonObject)gson.fromJson(raw, JsonObject.class);
                    Builder data = new Builder(json);
                    data.buildingEntry().getModuleProducers().add(new BuildingEntry.ModuleProducer(data.name(), () -> new CustomCraftingModule(data), () -> CraftingModuleView::new));
                    MineColoniesTweaks.LOGGER.info("CustomCraftingModule Added: " + data.name());
                }
                catch (Exception e) {
                    MineColoniesTweaks.LOGGER.error("Exception during load CustomCraftingModule: " + raw, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            MineColoniesTweaks.LOGGER.error("Exception during load CustomCraftingModule", (Throwable)e);
        }
    }

    public CustomCraftingModule(Builder builder) {
        super(builder.jobEntry);
        this.name = builder.name;
        this.forceVisible = builder.forceVisible;
    }

    @NotNull
    public String getId() {
        return this.name;
    }

    public boolean isVisible() {
        return this.forceVisible || super.isVisible();
    }

    public static class Builder {
        private final String name;
        private BuildingEntry buildingEntry;
        private JobEntry jobEntry;
        private boolean forceVisible;

        public Builder(JsonObject json) {
            this.name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            ResourceLocation buildinId = GsonHelper2.getAsResourceLocation(json, "buildingId", "minecolonies");
            ResourceLocation jobId = GsonHelper2.getAsResourceLocation(json, "jobId", "minecolonies");
            this.forceVisible = GsonHelper.m_13855_((JsonObject)json, (String)"forceVisible", (boolean)false);
            this.buildingEntry = (BuildingEntry)IMinecoloniesAPI.getInstance().getBuildingRegistry().getValue(buildinId);
            if (this.buildingEntry == null) {
                throw new RuntimeException("BuildingEntry '" + buildinId + "' is not found during load CustomCraftingModule");
            }
            this.jobEntry = (JobEntry)IMinecoloniesAPI.getInstance().getJobRegistry().getValue(jobId);
            if (this.jobEntry == null) {
                throw new RuntimeException("JobEntry '" + jobId + "' is not found during load CustomCraftingModule");
            }
        }

        public String name() {
            return this.name;
        }

        public Builder buildingEntry(BuildingEntry buildingEntry) {
            this.buildingEntry = buildingEntry;
            return this;
        }

        public BuildingEntry buildingEntry() {
            return this.buildingEntry;
        }

        public Builder jobEntry(JobEntry jobEntry) {
            this.jobEntry = jobEntry;
            return this;
        }

        public JobEntry jobEntry() {
            return this.jobEntry;
        }

        public Builder forceVisible(boolean forceVisible) {
            this.forceVisible = forceVisible;
            return this;
        }

        public boolean forceVisible() {
            return this.forceVisible;
        }
    }
}

