/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.api.common.tool;

import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_tweaks.api.common.tool.CustomToolType;

public class OrToolType
extends CustomToolType {
    private final List<Supplier<EquipmentTypeEntry>> toolTypes;

    public OrToolType(ResourceLocation name, Collection<Supplier<EquipmentTypeEntry>> toolTypes) {
        super(name);
        this.toolTypes = toolTypes.stream().toList();
    }

    public List<Supplier<EquipmentTypeEntry>> getToolTypes() {
        return this.toolTypes;
    }

    @Override
    public int getToolLevel(@NotNull ItemStack stack) {
        for (Supplier<EquipmentTypeEntry> supplier : this.getToolTypes()) {
            EquipmentTypeEntry toolType = supplier.get();
            int level = toolType.getMiningLevel(stack);
            if (level <= -1) continue;
            return level;
        }
        return super.getToolLevel(stack);
    }

    @Override
    public boolean isTool(@NotNull ItemStack stack) {
        for (Supplier<EquipmentTypeEntry> supplier : this.getToolTypes()) {
            EquipmentTypeEntry toolType = supplier.get();
            if (!toolType.checkIsEquipment(stack)) continue;
            return true;
        }
        return super.isTool(stack);
    }
}

