/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SyncPreviewCacheToClient
implements IMessage {
    public static final String SHARED_PREFIX = "shared:";
    private final BlueprintPreviewData previewData;
    private final UUID playerUUID;

    public SyncPreviewCacheToClient(FriendlyByteBuf buf) {
        this.previewData = new BlueprintPreviewData(buf, false);
        this.playerUUID = buf.m_130259_();
    }

    public SyncPreviewCacheToClient(BlueprintPreviewData previewData, UUID playerUUID) {
        this.previewData = previewData;
        this.playerUUID = playerUUID;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        this.previewData.writeToBuf(buf);
        buf.m_130077_(this.playerUUID);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        String uuid = SHARED_PREFIX + this.playerUUID.toString();
        if (this.previewData.isEmpty()) {
            if (RenderingCache.hasBlueprint(uuid)) {
                RenderingCache.removeBlueprint(uuid);
            }
        } else {
            RenderingCache.queue(uuid, this.previewData);
        }
    }
}

