/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui.util;

import com.ldtteam.structurize.api.util.ItemStorage;
import com.ldtteam.structurize.api.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class ItemPositionsStorage {
    public final ItemStorage itemStorage;
    public final List<BlockPos> positions = new ArrayList<BlockPos>();

    public ItemPositionsStorage(ItemStorage itemStorage) {
        this.itemStorage = itemStorage;
    }

    public ItemPositionsStorage(FriendlyByteBuf buf) {
        this.itemStorage = new ItemStorage(buf);
        int count = buf.m_130242_();
        for (int i = 0; i < count; ++i) {
            this.positions.add(new BlockPos(buf.m_130242_(), buf.m_130242_(), buf.m_130242_()));
        }
    }

    public void addPos(BlockPos pos) {
        this.positions.add(pos);
    }

    public void addItemAndPos(ItemStorage toAdd, BlockPos pos) {
        if (!toAdd.equals(this.itemStorage)) {
            Log.getLogger().warn("Tried to add a different item to the item storage!", (Throwable)new Exception());
            return;
        }
        this.positions.add(pos);
        this.itemStorage.setAmount(this.positions.size());
    }

    public void removePos(BlockPos pos) {
        this.positions.remove(pos);
    }

    public boolean isEmpty() {
        return this.positions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemPositionsStorage)) {
            return false;
        }
        ItemPositionsStorage that = (ItemPositionsStorage)o;
        return Objects.equals(this.itemStorage, that.itemStorage);
    }

    public int hashCode() {
        return Objects.hashCode(this.itemStorage);
    }

    public void serialize(FriendlyByteBuf buf) {
        this.itemStorage.serialize(buf);
        buf.m_130130_(this.positions.size());
        for (BlockPos pos : this.positions) {
            buf.m_130130_(pos.m_123341_());
            buf.m_130130_(pos.m_123342_());
            buf.m_130130_(pos.m_123343_());
        }
    }
}

