/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import reloc.org.sat4j.core.VecInt;
import reloc.org.sat4j.pb.constraints.pb.ConflictMap;
import reloc.org.sat4j.pb.constraints.pb.IPostProcess;
import reloc.org.sat4j.specs.IteratorInt;

public class PostProcessToCard
implements IPostProcess {
    private static final PostProcessToCard INSTANCE = new PostProcessToCard();
    private int assertiveLevel;

    private PostProcessToCard() {
    }

    public static final PostProcessToCard instance() {
        return INSTANCE;
    }

    @Override
    public void postProcess(int dl, ConflictMap conflictMap) {
        if (conflictMap.isAssertive(dl) && !conflictMap.degree.equals(BigInteger.ONE)) {
            conflictMap.setDecisionLevel(dl);
            if (conflictMap.assertiveLiteral != -1) {
                int lit;
                int ilit;
                conflictMap.assertiveLiteral = this.chooseAssertiveLiteral(dl, conflictMap);
                BigInteger coefLit = conflictMap.weightedLits.getCoef(conflictMap.assertiveLiteral);
                BigInteger sumCoefsTmp = BigInteger.ZERO;
                for (int i = 0; i < conflictMap.size(); ++i) {
                    sumCoefsTmp = sumCoefsTmp.add(conflictMap.weightedLits.getCoef(i));
                }
                if (sumCoefsTmp.compareTo(BigInteger.valueOf(conflictMap.size())) == 0) {
                    return;
                }
                VecInt compLSet = new VecInt();
                BigInteger coefMax = coefLit;
                sumCoefsTmp = sumCoefsTmp.subtract(coefLit);
                conflictMap.changeCoef(conflictMap.assertiveLiteral, BigInteger.ONE);
                for (int i = 0; i < conflictMap.size(); ++i) {
                    ilit = conflictMap.weightedLits.getLit(i);
                    lit = conflictMap.weightedLits.getLit(conflictMap.assertiveLiteral);
                    int litLevel = conflictMap.voc.getLevel(ilit);
                    BigInteger coefTmp = conflictMap.weightedLits.getCoef(i);
                    if (ilit == lit) continue;
                    if (litLevel < this.assertiveLevel && conflictMap.voc.isFalsified(ilit)) {
                        conflictMap.changeCoef(i, BigInteger.ONE);
                        sumCoefsTmp = sumCoefsTmp.subtract(coefTmp);
                        if (coefMax.compareTo(coefTmp) >= 0) continue;
                        coefMax = coefTmp;
                        continue;
                    }
                    compLSet.push(ilit);
                }
                assert (sumCoefsTmp.compareTo(conflictMap.degree) < 0);
                lit = conflictMap.weightedLits.getLit(conflictMap.assertiveLiteral);
                int degreeCard = 1;
                for (int i = 0; i < compLSet.size(); ++i) {
                    ilit = conflictMap.weightedLits.getFromAllLits(compLSet.get(i));
                    if (coefMax.compareTo(conflictMap.weightedLits.getCoef(ilit)) <= 0) {
                        conflictMap.changeCoef(ilit, BigInteger.ONE);
                        ++degreeCard;
                        continue;
                    }
                    conflictMap.removeCoef(compLSet.get(i));
                }
                conflictMap.degree = BigInteger.valueOf(degreeCard);
                conflictMap.assertiveLiteral = conflictMap.weightedLits.getFromAllLits(lit);
                assert (conflictMap.backtrackLevel == conflictMap.oldGetBacktrackLevel(dl));
            }
        }
    }

    private int chooseAssertiveLiteral(int maxLevel, ConflictMap conflictMap) {
        int indStop = ConflictMap.levelToIndex(maxLevel);
        int indStart = ConflictMap.levelToIndex(0);
        BigInteger slack = conflictMap.computeSlack(0).subtract(conflictMap.degree);
        int previous = 0;
        VecInt literals = new VecInt();
        for (int indLevel = indStart; indLevel <= indStop; ++indLevel) {
            if (conflictMap.byLevel[indLevel] == null) continue;
            int level = ConflictMap.indexToLevel(indLevel);
            assert (conflictMap.computeSlack(level).subtract(conflictMap.degree).equals(slack));
            if (conflictMap.isImplyingLiteralOrdered(level, slack, literals)) {
                this.assertiveLevel = level;
                conflictMap.backtrackLevel = previous;
                break;
            }
            VecInt lits = conflictMap.byLevel[indLevel];
            IteratorInt iterator = lits.iterator();
            while (iterator.hasNext()) {
                int lit = iterator.next();
                if (!conflictMap.voc.isFalsified(lit) || conflictMap.voc.getLevel(lit) != ConflictMap.indexToLevel(indLevel)) continue;
                slack = slack.subtract(conflictMap.weightedLits.get(lit));
            }
            if (lits.isEmpty()) continue;
            previous = level;
        }
        assert (literals.size() > 0);
        int maxLit = literals.get(0);
        BigInteger maxCoef = conflictMap.weightedLits.getCoef(maxLit);
        for (int i = 1; i < literals.size(); ++i) {
            BigInteger coef = conflictMap.weightedLits.getCoef(literals.get(i));
            if (coef.compareTo(maxCoef) <= 0) continue;
            maxLit = literals.get(i);
            maxCoef = coef;
        }
        assert (conflictMap.backtrackLevel == conflictMap.oldGetBacktrackLevel(maxLevel));
        assert (literals.size() > 0);
        return maxLit;
    }

    public String toString() {
        return "Performs a post-processing after conflict analysis in order to learn only cardinality constraints (Dixon's procedure)";
    }
}

