/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl;

import cpw.mods.modlauncher.api.INameMappingService;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import reloc.net.minecraftforge.srgutils.IMappingBuilder;
import reloc.net.minecraftforge.srgutils.IMappingFile;
import reloc.net.minecraftforge.srgutils.INamedMappingFile;

public class MappingResolverImpl
implements MappingResolver {
    private static final String MAPPINGS_RESOURCE = "/mappings.tsrg";
    private static final String FML_NAMESPACE = FMLEnvironment.naming;
    private static final String OBF_NAMESPACE = "srg";
    private final INamedMappingFile mappings;

    public MappingResolverImpl() {
        URL path = this.getClass().getResource(MAPPINGS_RESOURCE);
        if (path == null && !FMLEnvironment.production) {
            throw new RuntimeException("Missing mappings file");
        }
        try (InputStream is = path.openStream();){
            INamedMappingFile map = INamedMappingFile.load(is);
            List<String> names = map.getNames();
            if (!FML_NAMESPACE.equals(OBF_NAMESPACE) && names.contains(OBF_NAMESPACE)) {
                IMappingBuilder builder = IMappingBuilder.create((String[])Stream.concat(map.getNames().stream(), Stream.of(FML_NAMESPACE)).toArray(String[]::new));
                BiFunction mapper = (BiFunction)FMLLoader.getNameFunction((String)OBF_NAMESPACE).orElseThrow();
                ArrayList<String> filtered = new ArrayList<String>(names);
                filtered.remove(OBF_NAMESPACE);
                IMappingFile primary = map.getMap((String)filtered.get(0), OBF_NAMESPACE);
                primary.getClasses().forEach(cls -> {
                    IMappingBuilder.IClass newCls = builder.addClass(MappingResolverImpl.getNames(map, filtered, cls, IMappingFile::getClass, cls.getMapped()));
                    cls.getMethods().forEach(mtd -> newCls.method(mtd.getDescriptor(), MappingResolverImpl.getNames(map, filtered, mtd, (m, name) -> m.getClass(cls.getOriginal()).getMethod((String)name, mtd.getDescriptor()), MappingResolverImpl.mapMethodNameIncludingRecords(mapper, mtd.getMapped()))));
                    cls.getFields().forEach(fd -> newCls.field(MappingResolverImpl.getNames(map, filtered, fd, (m, name) -> m.getClass(cls.getOriginal()).getField((String)name), (String)mapper.apply(INameMappingService.Domain.FIELD, fd.getMapped()))).descriptor(fd.getDescriptor()));
                });
                primary.getPackages().forEach(pkg -> builder.addPackage(MappingResolverImpl.getNames(map, filtered, pkg, IMappingFile::getPackage, pkg.getOriginal())));
                this.mappings = builder.build();
            } else {
                this.mappings = map;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String mapMethodNameIncludingRecords(BiFunction<INameMappingService.Domain, String, String> mapper, String name) {
        String mapped = mapper.apply(INameMappingService.Domain.METHOD, name);
        if (mapped.equals(name)) {
            mapped = mapper.apply(INameMappingService.Domain.FIELD, name);
        }
        return mapped;
    }

    private static String[] getNames(INamedMappingFile map, List<String> namespaces, IMappingFile.INode node, BiFunction<IMappingFile, String, IMappingFile.INode> resolver, String ... additional) {
        String[] arr = new String[map.getNames().size() + additional.length];
        arr[0] = node.getOriginal();
        arr[1] = node.getMapped();
        for (int i = 2; i <= namespaces.size(); ++i) {
            IMappingFile mappingFile = map.getMap(namespaces.get(0), namespaces.get(i - 1));
            arr[i] = resolver.apply(mappingFile, node.getOriginal()).getMapped();
        }
        System.arraycopy(additional, 0, arr, arr.length - additional.length, additional.length);
        return arr;
    }

    public IMappingFile getCurrentMap(String from) {
        return this.getMap(from, FML_NAMESPACE);
    }

    public IMappingFile getMap(String from, String to) {
        return this.mappings.getMap(from, to);
    }

    public String mapDescriptor(String namespace, String descriptor) {
        return this.getCurrentMap(namespace).remapDescriptor(descriptor);
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.mappings.getNames();
    }

    @Override
    public String getCurrentRuntimeNamespace() {
        return FML_NAMESPACE;
    }

    @Override
    public String mapClassName(String namespace, String className) {
        return MappingResolverImpl.toBinaryName(this.getCurrentMap(namespace).remapClass(MappingResolverImpl.toInternalName(className)));
    }

    @Override
    public String unmapClassName(String targetNamespace, String className) {
        return MappingResolverImpl.toBinaryName(this.getMap(FML_NAMESPACE, targetNamespace).remapClass(MappingResolverImpl.toInternalName(className)));
    }

    @Override
    public String mapFieldName(String namespace, String owner, String name, String descriptor) {
        return Optional.ofNullable(this.getCurrentMap(namespace).getClass(MappingResolverImpl.toInternalName(owner))).map(cls -> cls.remapField(name)).orElse(name);
    }

    @Override
    public String mapMethodName(String namespace, String owner, String name, String descriptor) {
        return Optional.ofNullable(this.getCurrentMap(namespace).getClass(MappingResolverImpl.toInternalName(owner))).map(cls -> cls.remapMethod(name, descriptor)).orElse(name);
    }

    private static String toBinaryName(String className) {
        return className.replace('/', '.');
    }

    private static String toInternalName(String className) {
        return className.replace('.', '/');
    }
}

