/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.util;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.network.CloseCurrentScreenMessage;
import dev.muon.otherworldorigins.network.SendFeatLayersMessage;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class FeatHandler {
    private static final List<ResourceLocation> FEAT_LAYERS = Arrays.asList(OtherworldOrigins.loc("first_feat"), OtherworldOrigins.loc("second_feat"), OtherworldOrigins.loc("third_feat"), OtherworldOrigins.loc("fourth_feat"), OtherworldOrigins.loc("fifth_feat"));

    public static void checkForFeats(ServerPlayer player) {
        MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry((MinecraftServer)player.m_9236_().m_7654_());
        IOriginContainer originContainer = IOriginContainer.get((Entity)player).resolve().orElse(null);
        if (originContainer == null) {
            return;
        }
        ArrayList<ResourceLocation> availableFeatLayers = new ArrayList<ResourceLocation>();
        for (ResourceLocation layerId : FEAT_LAYERS) {
            ResourceKey layerKey = ResourceKey.m_135785_((ResourceKey)layerRegistry.m_123023_(), (ResourceLocation)layerId);
            Holder layerHolder = layerRegistry.m_203636_(layerKey).orElse(null);
            if (layerHolder == null) continue;
            OriginLayer layer = (OriginLayer)layerHolder.m_203334_();
            ResourceKey currentOrigin = originContainer.getOrigin(layerHolder);
            if (!currentOrigin.m_135782_().equals((Object)new ResourceLocation("origins", "empty")) || layer.origins((Player)player).isEmpty()) continue;
            availableFeatLayers.add(layerId);
        }
        if (!availableFeatLayers.isEmpty()) {
            player.m_6330_(SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> player);
            OtherworldOrigins.CHANNEL.send(target, (Object)new CloseCurrentScreenMessage());
            OtherworldOrigins.CHANNEL.send(target, (Object)new SendFeatLayersMessage(availableFeatLayers));
        }
    }
}

