/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.util;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.client.screen.FinalConfirmScreen;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientLayerScreenHelper {
    private static int validationAttempts = 0;
    private static final int MAX_VALIDATION_ATTEMPTS = 20;
    private static final Set<ResourceLocation> lastSelectedLayers = new HashSet<ResourceLocation>();

    @OnlyIn(value=Dist.CLIENT)
    public static void handleValidatedLayers(List<ResourceLocation> validMissingLayers) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            if (++validationAttempts >= 20) {
                ClientLayerScreenHelper.resetValidationAttempts();
                minecraft.execute(() -> minecraft.f_91074_.f_108617_.m_104910_().m_129507_((Component)Component.m_237115_((String)"otherworldorigins.disconnect.validation_failed")));
                return;
            }
            MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry(null);
            ArrayList<Holder.Reference> missingOriginLayers = new ArrayList<Holder.Reference>();
            for (ResourceLocation resourceLocation : validMissingLayers) {
                OriginLayer layer = (OriginLayer)layerRegistry.m_7745_(resourceLocation);
                if (layer == null) continue;
                missingOriginLayers.add(layerRegistry.m_246971_((ResourceKey)layerRegistry.m_7854_((Object)layer).orElseThrow()));
            }
            if (!missingOriginLayers.isEmpty()) {
                OtherworldOrigins.LOGGER.info("Reopening selection screen for validated layers:");
                for (Holder holder : missingOriginLayers) {
                    OtherworldOrigins.LOGGER.info("- " + ((OriginLayer)holder.m_203334_()).name().getString());
                }
                minecraft.execute(() -> {
                    ChooseOriginScreen newScreen = new ChooseOriginScreen(missingOriginLayers, 0, false);
                    minecraft.m_91152_((Screen)newScreen);
                });
            }
        }
    }

    public static void resetValidationAttempts() {
        validationAttempts = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setFinalConfirmScreen() {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_91152_((Screen)new FinalConfirmScreen());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleFeatLayers(List<ResourceLocation> validLayerIds) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry(null);
            ArrayList<Holder.Reference> featOriginLayers = new ArrayList<Holder.Reference>();
            for (ResourceLocation resourceLocation : validLayerIds) {
                OriginLayer layer = (OriginLayer)layerRegistry.m_7745_(resourceLocation);
                if (layer == null) continue;
                featOriginLayers.add(layerRegistry.m_246971_((ResourceKey)layerRegistry.m_7854_((Object)layer).orElseThrow()));
            }
            if (!featOriginLayers.isEmpty()) {
                OtherworldOrigins.LOGGER.debug("Opening selection screen for feat layers:");
                for (Holder holder : featOriginLayers) {
                    OtherworldOrigins.LOGGER.debug("- " + ((OriginLayer)holder.m_203334_()).name().getString());
                }
                minecraft.execute(() -> {
                    ChooseOriginScreen newScreen = new ChooseOriginScreen(featOriginLayers, 0, false);
                    minecraft.m_91152_((Screen)newScreen);
                });
            }
        }
    }

    public static void addToSelectedLayers(Set<ResourceLocation> layers) {
        lastSelectedLayers.addAll(layers);
        OtherworldOrigins.LOGGER.debug("Added layers to tracking: {}. Total tracked: {}", layers, lastSelectedLayers);
    }

    public static void clearSelectedLayers() {
        OtherworldOrigins.LOGGER.debug("Clearing tracked layers. Previous: {}", lastSelectedLayers);
        lastSelectedLayers.clear();
    }

    public static boolean wasOnlyFeatLayersSelected() {
        if (lastSelectedLayers.isEmpty()) {
            OtherworldOrigins.LOGGER.debug("wasOnlyFeatLayersSelected: false (no layers tracked)");
            return false;
        }
        HashSet<ResourceLocation> featLayerIds = new HashSet<ResourceLocation>();
        featLayerIds.add(OtherworldOrigins.loc("first_feat"));
        featLayerIds.add(OtherworldOrigins.loc("second_feat"));
        featLayerIds.add(OtherworldOrigins.loc("third_feat"));
        featLayerIds.add(OtherworldOrigins.loc("fourth_feat"));
        featLayerIds.add(OtherworldOrigins.loc("fifth_feat"));
        featLayerIds.add(OtherworldOrigins.loc("plus_one_aptitude_resilient"));
        for (ResourceLocation layerId : lastSelectedLayers) {
            if (featLayerIds.contains(layerId)) continue;
            OtherworldOrigins.LOGGER.debug("wasOnlyFeatLayersSelected: false (found non-feat layer: {})", (Object)layerId);
            return false;
        }
        OtherworldOrigins.LOGGER.debug("wasOnlyFeatLayersSelected: true. All {} tracked layers are feat layers", (Object)lastSelectedLayers.size());
        return true;
    }
}

