/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.spells;

import dev.muon.otherworldorigins.ForgeEvents;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.AbstractConeProjectile;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public abstract class AbstractDragonBreathSpell
extends AbstractSpell {
    private final ResourceLocation spellId;

    public AbstractDragonBreathSpell(String spellName) {
        this.spellId = new ResourceLocation("otherworldorigins", spellName);
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 3;
        this.spellPowerPerLevel = 1;
        this.castTime = 100;
        this.baseManaCost = 5;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(this.getSchoolType().getId()).setMaxLevel(10).setCooldownSeconds(12.0).build();
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11894_);
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.FIRE_BREATH_LOOP.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_SPIT_ANIMATION;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SPIT_FINISH_ANIMATION;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        AbstractConeProjectile coneProjectile = this.createConeProjectile(world, entity);
        coneProjectile.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() * 0.7, 0.0));
        coneProjectile.setDamage(this.getDamage(spellLevel, entity));
        world.m_7967_((Entity)coneProjectile);
        ForgeEvents.trackConeProjectile(coneProjectile);
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    protected abstract AbstractConeProjectile createConeProjectile(Level var1, LivingEntity var2);

    public void onClientPreCast(Level level, int spellLevel, LivingEntity entity, InteractionHand hand, @Nullable MagicData playerMagicData) {
        this.playSound(this.getCastStartSound(), (Entity)entity);
    }

    public float getDamage(int spellLevel, LivingEntity caster) {
        return 1.0f + this.getSpellPower(spellLevel, (Entity)caster) * 0.75f;
    }

    public boolean shouldAIStopCasting(int spellLevel, Mob mob, LivingEntity target) {
        return mob.m_20280_((Entity)target) > 120.0;
    }

    public abstract SchoolType getSchoolType();

    protected SchoolType getSchoolTypeFromRegistry(RegistryObject<SchoolType> registryObject) {
        return (SchoolType)registryObject.get();
    }
}

