/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.restrictions;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.config.OtherworldOriginsConfig;
import dev.muon.otherworldorigins.restrictions.SpellCategory;
import dev.muon.otherworldorigins.restrictions.SpellCategoryMapper;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class SpellRestrictions {
    private static Map<String, Set<SpellCategory>> SUBCLASS_SPELL_RESTRICTIONS = new HashMap<String, Set<SpellCategory>>();
    private static Map<String, Set<ResourceLocation>> SUBCLASS_SCHOOL_RESTRICTIONS = new HashMap<String, Set<ResourceLocation>>();
    private static final Map<UUID, PlayerClassInfo> playerClassCache = new ConcurrentHashMap<UUID, PlayerClassInfo>();

    public static void initializeFromConfig() {
        HashMap<String, Set<SpellCategory>> newRestrictions = new HashMap<String, Set<SpellCategory>>();
        HashMap<String, Set<ResourceLocation>> newSchoolRestrictions = new HashMap<String, Set<ResourceLocation>>();
        OtherworldOriginsConfig.getClassRestrictions().forEach((classPath, categories) -> {
            Set allowedCategories = categories.stream().map(cat -> SpellCategory.valueOf(cat.toUpperCase())).collect(Collectors.toSet());
            newRestrictions.put((String)classPath, allowedCategories);
        });
        OtherworldOriginsConfig.getSchoolRestrictions().forEach((classPath, schools) -> {
            Set allowedSchools = schools.stream().map(school -> {
                if (!school.contains(":")) {
                    return new ResourceLocation("irons_spellbooks", school);
                }
                return new ResourceLocation(school);
            }).collect(Collectors.toSet());
            newSchoolRestrictions.put((String)classPath, allowedSchools);
        });
        SUBCLASS_SPELL_RESTRICTIONS = newRestrictions;
        SUBCLASS_SCHOOL_RESTRICTIONS = newSchoolRestrictions;
    }

    public static Set<ResourceLocation> getAllowedSchools(String subclassKey) {
        return SUBCLASS_SCHOOL_RESTRICTIONS.getOrDefault(subclassKey, Collections.emptySet());
    }

    private static PlayerClassInfo getPlayerClassInfo(@NotNull Player player) {
        UUID playerUUID = player.m_20148_();
        PlayerClassInfo cachedInfo = playerClassCache.get(playerUUID);
        if (cachedInfo != null && !cachedInfo.isExpired()) {
            return cachedInfo;
        }
        return IOriginContainer.get((Entity)player).resolve().map(container -> {
            MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry((MinecraftServer)player.m_9236_().m_7654_());
            ResourceLocation classLayerLoc = OtherworldOrigins.loc("class");
            ResourceLocation subclassLayerLoc = OtherworldOrigins.loc("subclass");
            ResourceKey classLayerKey = ResourceKey.m_135785_((ResourceKey)layerRegistry.m_123023_(), (ResourceLocation)classLayerLoc);
            ResourceKey subclassLayerKey = ResourceKey.m_135785_((ResourceKey)layerRegistry.m_123023_(), (ResourceLocation)subclassLayerLoc);
            Holder classLayerHolder = layerRegistry.m_203636_(classLayerKey).orElse(null);
            Holder subclassLayerHolder = layerRegistry.m_203636_(subclassLayerKey).orElse(null);
            if (classLayerHolder == null || subclassLayerHolder == null) {
                OtherworldOrigins.LOGGER.warn("Class or subclass layer not found");
                return null;
            }
            ResourceKey playerClassKey = container.getOrigin(classLayerHolder);
            ResourceKey playerSubclassKey = container.getOrigin(subclassLayerHolder);
            if (playerClassKey == null || playerSubclassKey == null) {
                OtherworldOrigins.LOGGER.warn("Player class or subclass not found");
                return null;
            }
            String className = playerClassKey.m_135782_().m_135815_().replace("class/", "");
            String subclassName = playerSubclassKey.m_135782_().m_135815_().substring(playerSubclassKey.m_135782_().m_135815_().lastIndexOf(47) + 1);
            PlayerClassInfo newInfo = new PlayerClassInfo(className, subclassName);
            playerClassCache.put(playerUUID, newInfo);
            return newInfo;
        }).orElse(null);
    }

    public static boolean isSpellAllowed(Player player, AbstractSpell spell) {
        SchoolType spellSchool;
        if (OtherworldOriginsConfig.isSpellUnrestricted(spell)) {
            return true;
        }
        PlayerClassInfo classInfo = SpellRestrictions.getPlayerClassInfo(player);
        if (classInfo == null) {
            return true;
        }
        String fullSubclassKey = classInfo.className + "/" + classInfo.subclassName;
        Set<SpellCategory> subclassRestrictions = SUBCLASS_SPELL_RESTRICTIONS.get(fullSubclassKey);
        Set<ResourceLocation> schoolRestrictions = SUBCLASS_SCHOOL_RESTRICTIONS.get(fullSubclassKey);
        if (subclassRestrictions != null && subclassRestrictions.size() == 3) {
            return true;
        }
        if (subclassRestrictions != null && !subclassRestrictions.isEmpty()) {
            Set<SpellCategory> spellCategories = SpellCategoryMapper.getCategories(spell);
            for (SpellCategory category : spellCategories) {
                if (!subclassRestrictions.contains((Object)category)) continue;
                return true;
            }
        }
        if (schoolRestrictions != null && !schoolRestrictions.isEmpty() && (spellSchool = spell.getSchoolType()) != null && schoolRestrictions.contains(spellSchool.getId())) {
            return true;
        }
        return subclassRestrictions == null && schoolRestrictions == null;
    }

    public static Component getRestrictionMessage(Player player, AbstractSpell spell) {
        boolean hasSchools;
        PlayerClassInfo classInfo = SpellRestrictions.getPlayerClassInfo(player);
        if (classInfo == null) {
            return Component.m_237115_((String)"otherworldorigins.restriction.unknown").m_130940_(ChatFormatting.DARK_GRAY);
        }
        String fullSubclassKey = classInfo.className + "/" + classInfo.subclassName;
        Set<SpellCategory> allowedCategories = SUBCLASS_SPELL_RESTRICTIONS.get(fullSubclassKey);
        Set<ResourceLocation> allowedSchools = SUBCLASS_SCHOOL_RESTRICTIONS.get(fullSubclassKey);
        String formattedSubclass = Arrays.stream(classInfo.subclassName.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
        String formattedClass = classInfo.className.substring(0, 1).toUpperCase() + classInfo.className.substring(1).toLowerCase() + "s";
        MutableComponent subclassComponent = Component.m_237113_((String)(formattedSubclass + " " + formattedClass));
        boolean hasCategories = allowedCategories != null && !allowedCategories.isEmpty();
        boolean bl = hasSchools = allowedSchools != null && !allowedSchools.isEmpty();
        if (!hasCategories && !hasSchools) {
            return Component.m_237110_((String)"otherworldorigins.restriction.no_spells", (Object[])new Object[]{subclassComponent}).m_130940_(ChatFormatting.DARK_GRAY);
        }
        ArrayList<Component> allowedTypes = new ArrayList<Component>();
        if (hasCategories) {
            for (SpellCategory cat : allowedCategories) {
                String catName = cat.toString().substring(0, 1).toUpperCase() + cat.toString().substring(1).toLowerCase();
                allowedTypes.add((Component)Component.m_237113_((String)catName));
            }
        }
        if (hasSchools) {
            for (ResourceLocation schoolLoc : allowedSchools) {
                SchoolType schoolType = SpellRestrictions.getSchoolType(schoolLoc);
                if (schoolType == null) continue;
                Style schoolStyle = schoolType.getDisplayName().m_7383_();
                String schoolName = schoolLoc.m_135815_().substring(0, 1).toUpperCase() + schoolLoc.m_135815_().substring(1).toLowerCase();
                allowedTypes.add((Component)Component.m_237113_((String)schoolName).m_130948_(schoolStyle));
            }
        }
        Component listComponent = SpellRestrictions.formatComponentList(allowedTypes);
        return Component.m_237110_((String)"otherworldorigins.restriction.can_only_cast", (Object[])new Object[]{subclassComponent, listComponent}).m_130940_(ChatFormatting.DARK_GRAY);
    }

    private static SchoolType getSchoolType(ResourceLocation id) {
        if (SchoolRegistry.REGISTRY.get() == null) {
            return null;
        }
        return (SchoolType)((IForgeRegistry)SchoolRegistry.REGISTRY.get()).getValue(id);
    }

    private static Component formatComponentList(List<Component> items) {
        if (items.isEmpty()) {
            return Component.m_237119_();
        }
        if (items.size() == 1) {
            return items.get(0);
        }
        if (items.size() == 2) {
            return Component.m_237110_((String)"otherworldorigins.restriction.list.two", (Object[])new Object[]{items.get(0), items.get(1)});
        }
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < items.size(); ++i) {
            if (i > 0) {
                if (i == items.size() - 1) {
                    result.m_7220_((Component)Component.m_237115_((String)"otherworldorigins.restriction.list.last_separator"));
                } else {
                    result.m_7220_((Component)Component.m_237115_((String)"otherworldorigins.restriction.list.separator"));
                }
            }
            result.m_7220_(items.get(i));
        }
        return result;
    }

    public static void clearCache(Player player) {
        playerClassCache.remove(player.m_20148_());
    }

    private static class PlayerClassInfo {
        String className;
        String subclassName;
        long lastUpdateTime;

        PlayerClassInfo(String className, String subclassName) {
            this.className = className;
            this.subclassName = subclassName;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.lastUpdateTime > 10000L;
        }
    }
}

