/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.restrictions;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.config.OtherworldOriginsConfig;
import dev.muon.otherworldorigins.restrictions.SpellCategory;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class SpellCategoryMapper {
    private static final Map<ResourceLocation, Set<SpellCategory>> spellCategoryMap = new HashMap<ResourceLocation, Set<SpellCategory>>();

    public static void initialize() {
        spellCategoryMap.clear();
        SpellCategoryMapper.processSpellList((List)OtherworldOriginsConfig.OFFENSIVE_SPELLS.get(), SpellCategory.OFFENSIVE);
        SpellCategoryMapper.processSpellList((List)OtherworldOriginsConfig.SUPPORT_SPELLS.get(), SpellCategory.SUPPORT);
        SpellCategoryMapper.processSpellList((List)OtherworldOriginsConfig.DEFENSIVE_SPELLS.get(), SpellCategory.DEFENSIVE);
    }

    private static void processSpellList(List<? extends String> spellList, SpellCategory category) {
        for (String string : spellList) {
            try {
                ResourceLocation resourceLocation = SpellCategoryMapper.parseResourceLocation(string);
                if (SpellRegistry.getSpell((ResourceLocation)resourceLocation) == SpellRegistry.none()) {
                    OtherworldOrigins.LOGGER.warn("Spell {} not found in SpellRegistry", (Object)string);
                    continue;
                }
                spellCategoryMap.computeIfAbsent(resourceLocation, k -> new HashSet()).add(category);
            }
            catch (Exception e) {
                OtherworldOrigins.LOGGER.error("Invalid spell ID in config: {}", (Object)string, (Object)e);
            }
        }
    }

    public static Set<SpellCategory> getCategories(AbstractSpell spell) {
        ResourceLocation spellId = spell.getSpellResource();
        Set<SpellCategory> categories = spellCategoryMap.get(spellId);
        if (categories == null || categories.isEmpty()) {
            OtherworldOrigins.LOGGER.warn("No category mapping found for spell: {}, assuming it's a Damaging spell. Update the otherworldorigins-common config!", (Object)spellId);
            return Set.of(SpellCategory.OFFENSIVE);
        }
        return Collections.unmodifiableSet(categories);
    }

    private static ResourceLocation parseResourceLocation(String id) {
        if (!id.contains(":")) {
            return ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)id);
        }
        return ResourceLocation.parse((String)id);
    }
}

