/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.restrictions;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.config.OtherworldOriginsConfig;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentRestrictions {
    private static final Map<ResourceLocation, String> ENCHANTMENT_CLASS_MAP = new HashMap<ResourceLocation, String>();

    public static boolean isEnchantmentAllowed(Player player, Enchantment enchantment) {
        if (!((Boolean)OtherworldOriginsConfig.ENABLE_ENCHANTMENT_RESTRICTIONS.get()).booleanValue()) {
            return true;
        }
        ResourceLocation enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        if (enchantmentId == null) {
            return true;
        }
        String requiredClass = ENCHANTMENT_CLASS_MAP.get(enchantmentId);
        if (requiredClass == null) {
            return true;
        }
        return IOriginContainer.get((Entity)player).resolve().map(container -> {
            ResourceLocation classLayerLoc = OtherworldOrigins.loc("class");
            OriginLayer classLayer = (OriginLayer)OriginsAPI.getLayersRegistry().m_7745_(classLayerLoc);
            if (classLayer == null) {
                return true;
            }
            ResourceKey playerOrigin = container.getOrigin(ResourceKey.m_135785_((ResourceKey)OriginsAPI.getLayersRegistry().m_123023_(), (ResourceLocation)classLayerLoc));
            ResourceLocation requiredOriginLoc = OtherworldOrigins.loc("class/" + requiredClass);
            return playerOrigin.m_135782_().equals((Object)requiredOriginLoc);
        }).orElse(true);
    }

    public static String getRequiredClass(Enchantment enchantment) {
        ResourceLocation enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        if (enchantmentId == null) {
            return null;
        }
        return ENCHANTMENT_CLASS_MAP.get(enchantmentId);
    }

    public static List<Enchantment> getEnchantmentTextForClass(String className) {
        return ENCHANTMENT_CLASS_MAP.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(className)).filter(entry -> ((ResourceLocation)entry.getKey()).m_135827_().equals("minecraft")).map(entry -> (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue((ResourceLocation)entry.getKey())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static {
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("minecraft:mending"), "artificer");
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("backpacked:repairman"), "artificer");
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("minecraft:sweeping"), "barbarian");
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("minecraft:thorns"), "druid");
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("minecraft:sharpness"), "fighter");
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("minecraft:feather_falling"), "monk");
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("minecraft:smite"), "paladin");
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("minecraft:power"), "rogue");
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("minecraft:infinity"), "ranger");
        ENCHANTMENT_CLASS_MAP.put(new ResourceLocation("apotheosis:endless_quiver"), "ranger");
    }
}

