/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.power;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.otherworld.leveling.LevelingUtils;
import dev.muon.otherworld.leveling.event.AptitudeChangedEvent;
import dev.muon.otherworldorigins.power.ModPowers;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.calio.api.network.CalioCodecHelper;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherworldorigins")
public class LeveledAttributePower
extends PowerFactory<Configuration> {
    public LeveledAttributePower() {
        super(Configuration.CODEC);
        this.ticking(true);
    }

    public void tick(ConfiguredPower<Configuration, ?> configuredPower, Entity entity) {
        if (configuredPower.isActive(entity)) {
            ((Configuration)configuredPower.getConfiguration()).add(entity);
        } else {
            ((Configuration)configuredPower.getConfiguration()).remove(entity);
        }
    }

    protected int tickInterval(Configuration configuration, Entity entity) {
        return configuration.tickRate();
    }

    protected void onRemoved(Configuration configuration, Entity entity) {
        configuration.remove(entity);
    }

    @SubscribeEvent
    public static void onAptitudeChanged(AptitudeChangedEvent event) {
        Player entity;
        if (event.getNewLevel() > event.getOldLevel() && (entity = event.getPlayer()) instanceof Player) {
            Player player = entity;
            IPowerContainer.get((Entity)player).ifPresent(container -> container.getPowers((PowerFactory)ModPowers.LEVELED_ATTRIBUTE.get()).forEach(powerHolder -> ((Configuration)((ConfiguredPower)powerHolder.m_203334_()).getConfiguration()).update((Entity)player)));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            LeveledAttributePower.reapplyAllModifiers((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            LeveledAttributePower.reapplyAllModifiers((Player)player2);
        }
    }

    private static void reapplyAllModifiers(Player player) {
        IPowerContainer.get((Entity)player).ifPresent(container -> container.getPowers((PowerFactory)ModPowers.LEVELED_ATTRIBUTE.get()).forEach(powerHolder -> ((Configuration)((ConfiguredPower)powerHolder.m_203334_()).getConfiguration()).add((Entity)player)));
    }

    public record Configuration(Attribute attribute, AttributeModifier.Operation operation, double valuePerLevel, double startingValue, boolean updateHealth, int tickRate, UUID modifierUuid) implements IDynamicFeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.ATTRIBUTE.fieldOf("attribute").forGetter(Configuration::attribute), (App)SerializableDataTypes.MODIFIER_OPERATION.fieldOf("operation").forGetter(Configuration::operation), (App)Codec.DOUBLE.fieldOf("value_per_level").forGetter(Configuration::valuePerLevel), (App)Codec.DOUBLE.fieldOf("starting_value").forGetter(Configuration::startingValue), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.BOOL, (String)"update_health", (Object)true).forGetter(Configuration::updateHealth), (App)CalioCodecHelper.optionalField((Codec)CalioCodecHelper.INT, (String)"tick_rate", (Object)20).forGetter(Configuration::tickRate)).apply((Applicative)instance, (attr, op, vpl, sv, uh, tr) -> new Configuration((Attribute)attr, (AttributeModifier.Operation)op, (double)vpl, (double)sv, (boolean)uh, (int)tr, UUID.randomUUID())));

        public boolean isConfigurationValid() {
            return true;
        }

        public void add(Entity entity) {
            int n;
            LivingEntity living;
            block9: {
                block8: {
                    if (!(entity instanceof LivingEntity)) break block8;
                    living = (LivingEntity)entity;
                    if (!entity.m_9236_().m_5776_()) break block9;
                }
                return;
            }
            AttributeInstance attributeInstance = living.m_21051_(this.attribute);
            if (attributeInstance == null) {
                return;
            }
            if (attributeInstance.m_22111_(this.modifierUuid) != null) {
                return;
            }
            float previousMaxHealth = living.m_21233_();
            float previousHealthPercent = living.m_21223_() / previousMaxHealth;
            if (living instanceof Player) {
                Player player = (Player)living;
                n = LevelingUtils.getPlayerLevel((Player)player);
            } else {
                n = 1;
            }
            int level = n;
            double value = this.startingValue + (double)(level - 1) * this.valuePerLevel;
            AttributeModifier modifier = new AttributeModifier(this.modifierUuid, "Leveled Attribute Bonus", value, this.operation);
            attributeInstance.m_22118_(modifier);
            float afterMaxHealth = living.m_21233_();
            if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
                living.m_21153_(afterMaxHealth * previousHealthPercent);
            }
        }

        public void remove(Entity entity) {
            LivingEntity living;
            block6: {
                block5: {
                    if (!(entity instanceof LivingEntity)) break block5;
                    living = (LivingEntity)entity;
                    if (!entity.m_9236_().m_5776_()) break block6;
                }
                return;
            }
            AttributeInstance attributeInstance = living.m_21051_(this.attribute);
            if (attributeInstance == null || attributeInstance.m_22111_(this.modifierUuid) == null) {
                return;
            }
            float previousMaxHealth = living.m_21233_();
            float previousHealthPercent = living.m_21223_() / previousMaxHealth;
            attributeInstance.m_22120_(this.modifierUuid);
            float afterMaxHealth = living.m_21233_();
            if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
                living.m_21153_(afterMaxHealth * previousHealthPercent);
            }
        }

        public void update(Entity entity) {
            int n;
            LivingEntity living;
            block8: {
                block7: {
                    if (!(entity instanceof LivingEntity)) break block7;
                    living = (LivingEntity)entity;
                    if (!entity.m_9236_().m_5776_()) break block8;
                }
                return;
            }
            AttributeInstance attributeInstance = living.m_21051_(this.attribute);
            if (attributeInstance == null) {
                return;
            }
            float previousMaxHealth = living.m_21233_();
            float previousHealthPercent = living.m_21223_() / previousMaxHealth;
            attributeInstance.m_22120_(this.modifierUuid);
            if (living instanceof Player) {
                Player player = (Player)living;
                n = LevelingUtils.getPlayerLevel((Player)player);
            } else {
                n = 1;
            }
            int level = n;
            double value = this.startingValue + (double)(level - 1) * this.valuePerLevel;
            AttributeModifier modifier = new AttributeModifier(this.modifierUuid, "Leveled Attribute Bonus", value, this.operation);
            attributeInstance.m_22118_(modifier);
            float afterMaxHealth = living.m_21233_();
            if (this.updateHealth && afterMaxHealth != previousMaxHealth) {
                living.m_21153_(afterMaxHealth * previousHealthPercent);
            }
        }
    }
}

