/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.power;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.network.packet.client.SyncAptitudeCapabilityCP;
import com.seniors.justlevelingfork.registry.RegistryAptitudes;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import dev.muon.otherworld.leveling.LevelSyncHandler;
import dev.muon.otherworld.leveling.LevelingUtils;
import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.power.ModPowers;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class InnateAptitudeBonusPower
extends PowerFactory<Configuration> {
    public InnateAptitudeBonusPower() {
        super(Configuration.CODEC);
    }

    public void onGained(Configuration configuration, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.applyBonuses(player, configuration.aptitudeBonuses());
        }
    }

    public void onLost(Configuration configuration, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.removeBonuses(player, configuration.aptitudeBonuses());
        }
    }

    public static int getBonus(Entity entity, String aptitudeName) {
        IPowerContainer powerContainer = ApoliAPI.getPowerContainer((Entity)entity);
        if (powerContainer != null) {
            List playerPowers = powerContainer.getPowers((PowerFactory)ModPowers.INNATE_APTITUDE_BONUS.get());
            return playerPowers.stream().map(holder -> (Configuration)((ConfiguredPower)holder.m_203334_()).getConfiguration()).mapToInt(config -> config.aptitudeBonuses().getOrDefault(aptitudeName, 0)).sum();
        }
        return 0;
    }

    private void applyBonuses(Player player, Map<String, Integer> aptitudeBonuses) {
        AptitudeCapability cap = AptitudeCapability.get((Player)player);
        if (cap != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            aptitudeBonuses.forEach((aptitudeName, bonus) -> {
                Aptitude aptitude = RegistryAptitudes.getAptitude((String)aptitudeName);
                if (aptitude != null) {
                    int currentLevel = cap.getAptitudeLevel(aptitude);
                    cap.setAptitudeLevel(aptitude, currentLevel + bonus);
                }
            });
            SyncAptitudeCapabilityCP.send((Player)serverPlayer);
            int newPlayerLevel = LevelingUtils.getPlayerLevel((Player)player);
            LevelSyncHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new LevelSyncHandler.SyncPlayerLevelPacket(player.m_20148_(), newPlayerLevel));
        }
    }

    private void removeBonuses(Player player, Map<String, Integer> aptitudeBonuses) {
        AptitudeCapability cap = AptitudeCapability.get((Player)player);
        if (cap != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            aptitudeBonuses.forEach((aptitudeName, bonus) -> {
                Aptitude aptitude = RegistryAptitudes.getAptitude((String)aptitudeName);
                if (aptitude != null) {
                    int currentLevel = cap.getAptitudeLevel(aptitude);
                    int revertedLevel = Math.max(currentLevel - bonus, 1);
                    cap.setAptitudeLevel(aptitude, revertedLevel);
                } else {
                    OtherworldOrigins.LOGGER.warn("Aptitude not found: " + aptitudeName);
                }
            });
            SyncAptitudeCapabilityCP.send((Player)serverPlayer);
            int newPlayerLevel = LevelingUtils.getPlayerLevel((Player)player);
            LevelSyncHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new LevelSyncHandler.SyncPlayerLevelPacket(player.m_20148_(), newPlayerLevel));
        } else {
            OtherworldOrigins.LOGGER.warn("AptitudeCapability not found for player: " + player.m_7755_().getString());
        }
    }

    public record Configuration(Map<String, Integer> aptitudeBonuses) implements IDynamicFeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("aptitude_bonuses").forGetter(Configuration::aptitudeBonuses)).apply((Applicative)instance, Configuration::new));

        public boolean isConfigurationValid() {
            return !this.aptitudeBonuses.isEmpty();
        }
    }
}

