/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.network;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.util.ClientLayerScreenHelper;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.MappedRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SendValidatedLayersMessage {
    private final List<ResourceLocation> missingLayers;

    public SendValidatedLayersMessage(List<ResourceLocation> missingLayers) {
        this.missingLayers = missingLayers;
    }

    public static SendValidatedLayersMessage decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<ResourceLocation> layers = new ArrayList<ResourceLocation>(size);
        for (int i = 0; i < size; ++i) {
            layers.add(buf.m_130281_());
        }
        return new SendValidatedLayersMessage(layers);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.missingLayers.size());
        for (ResourceLocation layer : this.missingLayers) {
            buf.m_130085_(layer);
        }
    }

    public static void handle(SendValidatedLayersMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry(null);
            ArrayList<ResourceLocation> validMissingLayers = new ArrayList<ResourceLocation>();
            for (ResourceLocation layerId : message.missingLayers) {
                OriginLayer layer = (OriginLayer)layerRegistry.m_7745_(layerId);
                if (layer == null) continue;
                validMissingLayers.add(layerId);
            }
            if (!validMissingLayers.isEmpty()) {
                OtherworldOrigins.LOGGER.info("Server detected unpicked origins. Layers:");
                for (ResourceLocation layerId : validMissingLayers) {
                    OtherworldOrigins.LOGGER.info("- " + String.valueOf(layerId));
                }
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientLayerScreenHelper.handleValidatedLayers(validMissingLayers));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

