/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.network;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.util.ClientLayerScreenHelper;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.MappedRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SendFeatLayersMessage {
    private final List<ResourceLocation> featLayers;

    public SendFeatLayersMessage(List<ResourceLocation> featLayers) {
        this.featLayers = featLayers;
    }

    public static SendFeatLayersMessage decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<ResourceLocation> layers = new ArrayList<ResourceLocation>(size);
        for (int i = 0; i < size; ++i) {
            layers.add(buf.m_130281_());
        }
        return new SendFeatLayersMessage(layers);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.featLayers.size());
        for (ResourceLocation layer : this.featLayers) {
            buf.m_130085_(layer);
        }
    }

    public static void handle(SendFeatLayersMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry(null);
            ArrayList<ResourceLocation> validLayerIds = new ArrayList<ResourceLocation>();
            for (ResourceLocation layerId : message.featLayers) {
                OriginLayer layer = (OriginLayer)layerRegistry.m_7745_(layerId);
                if (layer == null) continue;
                validLayerIds.add(layerId);
            }
            if (!validLayerIds.isEmpty()) {
                OtherworldOrigins.LOGGER.debug("New feat(s) available. Layers:");
                for (ResourceLocation layerId : validLayerIds) {
                    OtherworldOrigins.LOGGER.debug("- " + String.valueOf(layerId));
                }
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientLayerScreenHelper.handleFeatLayers(validLayerIds));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

