/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.network;

import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2COpenOriginScreen;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ResetOriginsMessage {
    public static ResetOriginsMessage decode(FriendlyByteBuf buf) {
        return new ResetOriginsMessage();
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static void handle(ResetOriginsMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                IOriginContainer.get((Entity)player).ifPresent(container -> {
                    for (Holder.Reference layerRef : OriginsAPI.getActiveLayers()) {
                        container.setOrigin((OriginLayer)layerRef.get(), Origin.EMPTY);
                    }
                    container.checkAutoChoosingLayers(false);
                    PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> player);
                    OriginsCommon.CHANNEL.send(target, (Object)container.getSynchronizationPacket());
                    OriginsCommon.CHANNEL.send(target, (Object)new S2COpenOriginScreen(false));
                    container.synchronize();
                });
            }
        });
    }
}

