/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.network;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.network.OpenFinalConfirmScreenMessage;
import dev.muon.otherworldorigins.network.ResetValidationAttemptsMessage;
import dev.muon.otherworldorigins.network.SendValidatedLayersMessage;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class RequestLayerValidationMessage {
    public static RequestLayerValidationMessage decode(FriendlyByteBuf buf) {
        return new RequestLayerValidationMessage();
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static void handle(RequestLayerValidationMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                OtherworldOrigins.LOGGER.info("Received layer validation request from player: {}", (Object)player.m_7755_().getString());
                IOriginContainer originContainer = IOriginContainer.get((Entity)player).resolve().orElse(null);
                if (originContainer != null) {
                    MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry(null);
                    ArrayList<ResourceLocation> missingOriginLayers = new ArrayList<ResourceLocation>();
                    for (OriginLayer layer : layerRegistry) {
                        Holder.Reference layerHolder;
                        ResourceKey originKey;
                        ResourceLocation layerId = layerRegistry.m_7981_((Object)layer);
                        if (layerId == null || (originKey = originContainer.getOrigin((Holder)(layerHolder = layerRegistry.m_246971_((ResourceKey)layerRegistry.m_7854_((Object)layer).orElseThrow())))) != null && !originKey.m_135782_().equals((Object)new ResourceLocation("origins", "empty")) || layer.origins((Player)player).isEmpty()) continue;
                        missingOriginLayers.add(layerId);
                    }
                    if (!missingOriginLayers.isEmpty()) {
                        OtherworldOrigins.LOGGER.warn("Missing layers for player {}: {}", (Object)player.m_7755_().getString(), missingOriginLayers);
                        OtherworldOrigins.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SendValidatedLayersMessage(missingOriginLayers));
                    } else {
                        OtherworldOrigins.LOGGER.info("Layer validation successful for player {}. All origins are properly selected.", (Object)player.m_7755_().getString());
                        OtherworldOrigins.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ResetValidationAttemptsMessage());
                        OtherworldOrigins.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenFinalConfirmScreenMessage());
                    }
                } else {
                    OtherworldOrigins.LOGGER.error("Unable to get origin container for player: {}", (Object)player.m_7755_().getString());
                }
            } else {
                OtherworldOrigins.LOGGER.error("Received layer validation request from null player");
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

