/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.network;

import dev.muon.otherworldorigins.config.OtherworldOriginsConfig;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GiveStarterKitMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(GiveStarterKitMessage.class);

    public static GiveStarterKitMessage decode(FriendlyByteBuf buf) {
        return new GiveStarterKitMessage();
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static void handle(GiveStarterKitMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                if (!OtherworldOriginsConfig.SPEC.isLoaded()) {
                    LOGGER.warn("Config not loaded, cannot give starter kit");
                    return;
                }
                List starterKitItems = (List)OtherworldOriginsConfig.STARTER_KIT_ITEMS.get();
                for (String itemEntry : starterKitItems) {
                    try {
                        int count;
                        Item item;
                        String nbtStr;
                        String itemIdStr;
                        block13: {
                            String[] parts = itemEntry.split("\\|", 3);
                            if (parts.length < 2) {
                                LOGGER.warn("Invalid starter kit entry format: {}", (Object)itemEntry);
                                continue;
                            }
                            itemIdStr = parts[0].trim();
                            String countStr = parts[1].trim();
                            nbtStr = parts.length > 2 ? parts[2].trim() : "";
                            ResourceLocation itemId = ResourceLocation.parse((String)itemIdStr);
                            item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                            if (item == null) {
                                LOGGER.warn("Unknown item ID in starter kit: {}", (Object)itemIdStr);
                                continue;
                            }
                            try {
                                count = Integer.parseInt(countStr);
                                if (count <= 0) {
                                    LOGGER.warn("Invalid count in starter kit entry: {}", (Object)itemEntry);
                                }
                                break block13;
                            }
                            catch (NumberFormatException e) {
                                LOGGER.warn("Invalid count format in starter kit entry: {}", (Object)itemEntry);
                            }
                            continue;
                        }
                        ItemStack stack = new ItemStack((ItemLike)item, count);
                        if (!nbtStr.isEmpty()) {
                            try {
                                CompoundTag nbt = TagParser.m_129359_((String)nbtStr);
                                stack.m_41751_(nbt);
                            }
                            catch (Exception e) {
                                LOGGER.warn("Failed to parse NBT for starter kit item {}: {}", (Object)itemIdStr, (Object)e.getMessage());
                            }
                        }
                        if (player.m_150109_().m_36054_(stack)) continue;
                        player.m_36176_(stack, false);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error processing starter kit entry: {}", (Object)itemEntry, (Object)e);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

