/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.mixin.origins_patches;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.network.RequestLayerValidationMessage;
import dev.muon.otherworldorigins.restrictions.SpellRestrictions;
import dev.muon.otherworldorigins.util.ClientLayerScreenHelper;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WaitForNextLayerScreen.class}, remap=false)
public class WaitForNextLayerScreenMixin {
    @Shadow(remap=false)
    @Final
    private List<Holder<OriginLayer>> layerList;

    @Inject(method={"Lio/github/apace100/origins/screen/WaitForNextLayerScreen;openSelection()V"}, at={@At(value="HEAD")})
    private void onOpenSelectionStart(CallbackInfo ci) {
        if (this.layerList != null) {
            for (Holder<OriginLayer> layerHolder : this.layerList) {
                ResourceLocation layerId = layerHolder.m_203543_().map(key -> key.m_135782_()).orElse(null);
                if (layerId == null || !layerId.equals((Object)OtherworldOrigins.loc("race"))) continue;
                ClientLayerScreenHelper.clearSelectedLayers();
                break;
            }
        }
    }

    @Inject(method={"Lio/github/apace100/origins/screen/WaitForNextLayerScreen;openSelection()V"}, at={@At(value="RETURN", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V", remap=true, ordinal=2)})
    private void onOpenSelectionEnd(CallbackInfo ci) {
        OtherworldOrigins.LOGGER.info("Origin Selection is about to close, sending validation request to server");
        HashSet<ResourceLocation> selectedLayerIds = new HashSet<ResourceLocation>();
        if (this.layerList != null) {
            for (Holder<OriginLayer> layerHolder : this.layerList) {
                layerHolder.m_203543_().ifPresent(key -> selectedLayerIds.add(key.m_135782_()));
            }
        }
        ClientLayerScreenHelper.addToSelectedLayers(selectedLayerIds);
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_6937_(() -> OtherworldOrigins.CHANNEL.sendToServer((Object)new RequestLayerValidationMessage()));
        if (minecraft.f_91074_ != null) {
            SpellRestrictions.clearCache((Player)minecraft.f_91074_);
        }
    }
}

