/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.mixin.origins_patches;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.muon.otherworldorigins.config.OtherworldOriginsConfig;
import dev.muon.otherworldorigins.restrictions.EnchantmentRestrictions;
import io.github.apace100.origins.screen.OriginDisplayScreen;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.IForgeRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={OriginDisplayScreen.class}, remap=false)
public abstract class OriginDisplayScreenMixin {
    @Shadow
    public abstract Holder<Origin> getCurrentOrigin();

    @ModifyExpressionValue(method={"renderOriginContent"}, at={@At(value="INVOKE", ordinal=0, target="Lio/github/edwinmindcraft/origins/api/origin/Origin;getDescription()Lnet/minecraft/network/chat/Component;")})
    private Component appendSpellAndEnchantmentInfo(Component orgDesc) {
        Holder<Origin> currentOrigin = this.getCurrentOrigin();
        if (!currentOrigin.m_203633_()) {
            return orgDesc;
        }
        String originPath = currentOrigin.m_203543_().map(key -> key.m_135782_().m_135815_()).orElse("");
        MutableComponent modifiedDesc = orgDesc.m_6881_();
        if (originPath.startsWith("subclass/")) {
            modifiedDesc = this.appendSubclassSpellAccess(modifiedDesc, originPath.substring("subclass/".length()));
        } else if (originPath.startsWith("class/")) {
            modifiedDesc = this.appendClassSpellAccess(modifiedDesc, originPath.substring("class/".length()));
            modifiedDesc = this.appendEnchantmentAccess(modifiedDesc, originPath.substring("class/".length()));
        }
        return modifiedDesc;
    }

    @Unique
    private MutableComponent appendSubclassSpellAccess(MutableComponent desc, String path) {
        boolean hasSchools;
        Map<String, List<String>> categoryRestrictions = OtherworldOriginsConfig.getClassRestrictions();
        Map<String, List<String>> schoolRestrictions = OtherworldOriginsConfig.getSchoolRestrictions();
        List<String> categories = categoryRestrictions.get(path);
        List<String> schools = schoolRestrictions.get(path);
        boolean hasAllCategories = categories != null && new HashSet<String>(categories).containsAll(Arrays.asList("OFFENSIVE", "SUPPORT", "DEFENSIVE"));
        boolean hasCategories = categories != null && !categories.isEmpty();
        boolean bl = hasSchools = schools != null && !schools.isEmpty();
        if (hasAllCategories) {
            desc.m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"otherworldorigins.gui.spell_access").m_130938_(style -> style.m_131136_(Boolean.valueOf(true))));
            desc.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"otherworldorigins.gui.all_spells"));
            return desc;
        }
        if (!hasCategories && !hasSchools) {
            desc.m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"otherworldorigins.gui.spell_access").m_130938_(style -> style.m_131136_(Boolean.valueOf(true))));
            desc.m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"otherworldorigins.gui.no_spells"));
            return desc;
        }
        desc.m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"otherworldorigins.gui.spell_access").m_130938_(style -> style.m_131136_(Boolean.valueOf(true))));
        if (hasCategories) {
            desc.m_130946_("\n").m_7220_(this.otherworld$formatCategoryAccess(categories));
        }
        if (hasSchools) {
            desc.m_130946_("\n").m_7220_(this.otherworld$formatSchoolAccess(schools));
        }
        return desc;
    }

    @Unique
    private Component otherworld$formatCategoryAccess(List<String> categories) {
        if (categories.size() == 1) {
            String cat2 = categories.get(0);
            return Component.m_237110_((String)"otherworldorigins.gui.all_category_spells", (Object[])new Object[]{cat2.substring(0, 1).toUpperCase() + cat2.substring(1).toLowerCase()});
        }
        if (categories.size() == 2) {
            String cat1 = categories.get(0).substring(0, 1).toUpperCase() + categories.get(0).substring(1).toLowerCase();
            String cat2 = categories.get(1).substring(0, 1).toUpperCase() + categories.get(1).substring(1).toLowerCase();
            return Component.m_237110_((String)"otherworldorigins.gui.all_two_category_spells", (Object[])new Object[]{cat1, cat2});
        }
        String formatted = categories.stream().map(cat -> cat.substring(0, 1).toUpperCase() + cat.substring(1).toLowerCase()).collect(Collectors.joining(", "));
        return Component.m_237110_((String)"otherworldorigins.gui.all_category_spells", (Object[])new Object[]{formatted});
    }

    @Unique
    private Component otherworld$formatSchoolAccess(List<String> schoolIds) {
        ArrayList<SchoolType> schoolTypes = new ArrayList<SchoolType>();
        for (String schoolId : schoolIds) {
            ResourceLocation loc = schoolId.contains(":") ? new ResourceLocation(schoolId) : new ResourceLocation("irons_spellbooks", schoolId);
            SchoolType schoolType = this.otherworld$getSchoolType(loc);
            if (schoolType == null) continue;
            schoolTypes.add(schoolType);
        }
        if (schoolTypes.isEmpty()) {
            return Component.m_237119_();
        }
        if (schoolTypes.size() == 1) {
            Component schoolName = this.otherworld$getStyledSchoolName((SchoolType)schoolTypes.get(0));
            return Component.m_237110_((String)"otherworldorigins.gui.all_school_spells", (Object[])new Object[]{schoolName});
        }
        if (schoolTypes.size() == 2) {
            Component school1 = this.otherworld$getStyledSchoolName((SchoolType)schoolTypes.get(0));
            Component school2 = this.otherworld$getStyledSchoolName((SchoolType)schoolTypes.get(1));
            return Component.m_237110_((String)"otherworldorigins.gui.all_two_school_spells", (Object[])new Object[]{school1, school2});
        }
        MutableComponent schoolList = Component.m_237119_();
        for (int i = 0; i < schoolTypes.size(); ++i) {
            if (i > 0) {
                if (i == schoolTypes.size() - 1) {
                    schoolList.m_7220_((Component)Component.m_237113_((String)" and "));
                } else {
                    schoolList.m_7220_((Component)Component.m_237113_((String)", "));
                }
            }
            schoolList.m_7220_(this.otherworld$getStyledSchoolName((SchoolType)schoolTypes.get(i)));
        }
        return Component.m_237110_((String)"otherworldorigins.gui.all_school_spells", (Object[])new Object[]{schoolList});
    }

    @Unique
    private Component otherworld$getStyledSchoolName(SchoolType school) {
        Style schoolStyle = school.getDisplayName().m_7383_();
        return Component.m_237113_((String)this.otherworld$formatSchoolName(school)).m_130948_(schoolStyle);
    }

    @Unique
    private String otherworld$formatSchoolName(SchoolType school) {
        String name = school.getId().m_135815_();
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    @Unique
    private SchoolType otherworld$getSchoolType(ResourceLocation id) {
        if (SchoolRegistry.REGISTRY.get() == null) {
            return null;
        }
        return (SchoolType)((IForgeRegistry)SchoolRegistry.REGISTRY.get()).getValue(id);
    }

    @Unique
    private MutableComponent appendClassSpellAccess(MutableComponent desc, String className) {
        Map<String, List<String>> categoryRestrictions = OtherworldOriginsConfig.getClassRestrictions();
        Map<String, List<String>> schoolRestrictions = OtherworldOriginsConfig.getSchoolRestrictions();
        Set subclassCategoryRestrictions = categoryRestrictions.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(className + "/")).map(Map.Entry::getValue).collect(Collectors.toSet());
        Set subclassSchoolRestrictions = schoolRestrictions.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(className + "/")).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (subclassCategoryRestrictions.isEmpty() && subclassSchoolRestrictions.isEmpty()) {
            return desc;
        }
        desc.m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"otherworldorigins.gui.spell_access").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_178520_(0xCCFFFF)));
        boolean allNoSpells = subclassCategoryRestrictions.stream().allMatch(list -> list == null || list.isEmpty()) && subclassSchoolRestrictions.stream().allMatch(list -> list == null || list.isEmpty());
        boolean allAllSpells = subclassCategoryRestrictions.stream().allMatch(list -> list != null && new HashSet(list).containsAll(Arrays.asList("OFFENSIVE", "SUPPORT", "DEFENSIVE")));
        MutableComponent message = allNoSpells ? Component.m_237115_((String)"otherworldorigins.gui.no_spells").m_130938_(style -> style.m_178520_(0xCCFFFF)) : (allAllSpells ? Component.m_237115_((String)"otherworldorigins.gui.all_spells").m_130938_(style -> style.m_178520_(0xCCFFFF)) : Component.m_237115_((String)"otherworldorigins.gui.varies").m_130938_(style -> style.m_178520_(0xCCFFFF)));
        desc.m_130946_("\n").m_7220_((Component)message);
        return desc;
    }

    @Unique
    private MutableComponent appendEnchantmentAccess(MutableComponent desc, String className) {
        if (!((Boolean)OtherworldOriginsConfig.ENABLE_ENCHANTMENT_RESTRICTIONS.get()).booleanValue()) {
            return desc;
        }
        List<Enchantment> classEnchantments = EnchantmentRestrictions.getEnchantmentTextForClass(className);
        if (classEnchantments.isEmpty()) {
            return desc;
        }
        desc.m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"otherworldorigins.gui.enchantment_access").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)).m_178520_(0xFF66FF)));
        String formattedClass = className.substring(0, 1).toUpperCase() + className.substring(1).toLowerCase() + "s";
        for (Enchantment enchantment : classEnchantments) {
            MutableComponent enchantmentName = Component.m_237115_((String)enchantment.m_44704_());
            MutableComponent fullMessage = Component.m_237110_((String)"otherworldorigins.gui.enchantment_restriction", (Object[])new Object[]{formattedClass, enchantmentName}).m_130938_(style -> style.m_178520_(0xFF66FF));
            desc.m_130946_("\n").m_7220_((Component)Component.m_237113_((String)"\u2022 ")).m_7220_((Component)fullMessage);
        }
        return desc;
    }
}

