/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.mixin.origins_patches;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.network.ResetOriginsMessage;
import dev.muon.otherworldorigins.util.ClientLayerScreenHelper;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.apace100.origins.screen.OriginDisplayScreen;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChooseOriginScreen.class})
public class ChooseOriginScreenMixin
extends OriginDisplayScreen {
    @Unique
    private static final int MARGIN = 10;
    @Unique
    private static final int LINE_HEIGHT = 14;
    @Unique
    private static final int BUTTON_WIDTH = 100;
    @Unique
    private static final int BUTTON_HEIGHT = 20;
    @Final
    @Shadow(remap=false)
    private List<Holder<OriginLayer>> layerList;
    @Final
    @Shadow(remap=false)
    private int currentLayerIndex;

    @Unique
    private ChooseOriginScreen scrn() {
        return (ChooseOriginScreen)this;
    }

    public ChooseOriginScreenMixin(Component title, boolean showDirtBackground) {
        super(title, showDirtBackground);
    }

    @Inject(method={"Lio/github/apace100/origins/screen/ChooseOriginScreen;init()V"}, at={@At(value="TAIL")}, require=1)
    private void addResetButton(CallbackInfo ci) {
        if (this.otherworld$shouldHideButton()) {
            return;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"otherworldorigins.gui.start_over"), button -> {
            ClientLayerScreenHelper.clearSelectedLayers();
            OtherworldOrigins.CHANNEL.sendToServer((Object)new ResetOriginsMessage());
            this.scrn().m_7379_();
        }).m_252987_(10, this.scrn().f_96544_ - 20 - 10, 100, 20).m_253136_());
    }

    @Inject(method={"Lio/github/apace100/origins/screen/ChooseOriginScreen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")}, require=1)
    private void renderCurrentOrigins(GuiGraphics graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        int centerX = this.scrn().f_96543_ / 2;
        int centerY = this.scrn().f_96544_ / 2;
        int startX = centerX - 189;
        int startY = centerY + 9;
        ResourceLocation[] layerIds = new ResourceLocation[]{OtherworldOrigins.loc("race"), OtherworldOrigins.loc("subrace"), OtherworldOrigins.loc("class"), OtherworldOrigins.loc("subclass")};
        IOriginContainer originContainer = IOriginContainer.get((Entity)this.scrn().getMinecraft().f_91074_).resolve().orElse(null);
        if (originContainer != null) {
            MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry(null);
            MappedRegistry originRegistry = OriginsAPI.getOriginsRegistry(null);
            int y = startY;
            for (ResourceLocation layerId : layerIds) {
                Holder origin;
                ResourceKey originKey;
                ResourceKey layerKey = ResourceKey.m_135785_((ResourceKey)layerRegistry.m_123023_(), (ResourceLocation)layerId);
                Holder layer = layerRegistry.m_203636_(layerKey).orElse(null);
                if (layer == null || (originKey = originContainer.getOrigin(layer)) == null || originKey.m_135782_().equals((Object)new ResourceLocation("origins", "empty")) || (origin = (Holder)originRegistry.m_203636_(originKey).orElse(null)) == null) continue;
                MutableComponent layerName = ((OriginLayer)layer.m_203334_()).name().m_6881_().m_130938_(style -> style.m_131162_(Boolean.valueOf(true)));
                Component originName = ((Origin)origin.m_203334_()).getName();
                graphics.m_280430_(this.scrn().getMinecraft().f_91062_, (Component)Component.m_237110_((String)"otherworldorigins.gui.layer_origin", (Object[])new Object[]{layerName, originName}), startX, y, 0xFFFFFF);
                y += 14;
            }
            List<Holder<Origin>> featOrigins = this.otherworld$getFeatOriginsForRendering(originContainer, (Registry<OriginLayer>)layerRegistry, (Registry<Origin>)originRegistry);
            if (!featOrigins.isEmpty()) {
                int featX = centerX - 52;
                int featY = startY - 14;
                MutableComponent featsText = Component.m_237115_((String)"otherworldorigins.gui.feats").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)));
                graphics.m_280430_(this.scrn().getMinecraft().f_91062_, (Component)featsText, featX + 3, featY, 0xFFFFFF);
                featY += 15;
                int column2X = featX + 20;
                for (int i = 0; i < featOrigins.size(); ++i) {
                    Holder<Origin> origin = featOrigins.get(i);
                    int column = i % 2;
                    int row = i / 2;
                    int iconX = column == 0 ? featX : column2X;
                    int iconY = featY + row * 20;
                    this.otherworld$renderOriginIcon(graphics, (Origin)origin.m_203334_(), iconX, iconY, mouseX, mouseY);
                }
            }
        }
    }

    @Unique
    private boolean otherworld$shouldHideButton() {
        Holder<OriginLayer> currentLayer;
        ResourceLocation layerId;
        if (this.currentLayerIndex >= 0 && this.currentLayerIndex < this.layerList.size() && (layerId = (ResourceLocation)(currentLayer = this.layerList.get(this.currentLayerIndex)).m_203543_().map(ResourceKey::m_135782_).orElse(null)) != null) {
            return layerId.equals((Object)OtherworldOrigins.loc("first_feat")) || layerId.equals((Object)OtherworldOrigins.loc("second_feat")) || layerId.equals((Object)OtherworldOrigins.loc("third_feat")) || layerId.equals((Object)OtherworldOrigins.loc("fourth_feat")) || layerId.equals((Object)OtherworldOrigins.loc("fifth_feat")) || layerId.equals((Object)OtherworldOrigins.loc("plus_one_aptitude_resilient"));
        }
        return false;
    }

    @Unique
    private List<Holder<Origin>> otherworld$getFeatOriginsForRendering(IOriginContainer originContainer, Registry<OriginLayer> layerRegistry, Registry<Origin> originRegistry) {
        ResourceLocation[] featLayerIds;
        ArrayList<Holder<Origin>> featOrigins = new ArrayList<Holder<Origin>>();
        for (ResourceLocation layerId : featLayerIds = new ResourceLocation[]{OtherworldOrigins.loc("free_feat"), OtherworldOrigins.loc("first_feat"), OtherworldOrigins.loc("second_feat"), OtherworldOrigins.loc("third_feat"), OtherworldOrigins.loc("fourth_feat"), OtherworldOrigins.loc("fifth_feat")}) {
            Holder origin;
            ResourceKey originKey;
            ResourceKey layerKey = ResourceKey.m_135785_((ResourceKey)layerRegistry.m_123023_(), (ResourceLocation)layerId);
            Holder layer = layerRegistry.m_203636_(layerKey).orElse(null);
            if (layer == null || (originKey = originContainer.getOrigin(layer)) == null || originKey.m_135782_().equals((Object)new ResourceLocation("origins", "empty")) || (origin = (Holder)originRegistry.m_203636_(originKey).orElse(null)) == null) continue;
            featOrigins.add((Holder<Origin>)origin);
        }
        return featOrigins;
    }

    @Unique
    private void otherworld$renderOriginIcon(GuiGraphics graphics, Origin origin, int x, int y, int mouseX, int mouseY) {
        ItemStack icon = origin.getIcon();
        graphics.m_280480_(icon, x, y);
        if (mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16) {
            graphics.m_280557_(this.scrn().getMinecraft().f_91062_, origin.getName(), mouseX, mouseY);
        }
    }
}

