/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.mixin.compat.justlevelingfork;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.seniors.justlevelingfork.common.capability.AptitudeCapability;
import com.seniors.justlevelingfork.registry.RegistryCapabilities;
import com.seniors.justlevelingfork.registry.aptitude.Aptitude;
import dev.muon.otherworldorigins.power.InnateAptitudeBonusPower;
import dev.muon.otherworldorigins.util.FeatHandler;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AptitudeCapability.class}, remap=false)
public class AptitudeCapabilityMixin {
    @Unique
    private Player otherworld$player;

    @Inject(method={"addAptitudeLevel"}, at={@At(value="HEAD")})
    private void capturePlayer(Aptitude aptitude, int addLvl, CallbackInfo ci) {
        AptitudeCapability self = (AptitudeCapability)this;
        this.otherworld$player = this.otherworld$getPlayerFromCapability(self);
    }

    @ModifyExpressionValue(method={"addAptitudeLevel"}, at={@At(value="FIELD", target="Lcom/seniors/justlevelingfork/handler/HandlerCommonConfig;aptitudeMaxLevel:I")})
    private int increaseMaxByOriginBonus(int originalMaxLevel, Aptitude aptitude, int addLvl) {
        if (this.otherworld$player != null) {
            int bonus = InnateAptitudeBonusPower.getBonus((Entity)this.otherworld$player, aptitude.getName());
            return originalMaxLevel + bonus;
        }
        return originalMaxLevel;
    }

    @Inject(method={"addAptitudeLevel"}, at={@At(value="RETURN")})
    private void checkFeatEligibility(Aptitude aptitude, int addLvl, CallbackInfo ci) {
        Player player = this.otherworld$player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FeatHandler.checkForFeats(serverPlayer);
        }
    }

    @Unique
    private Player otherworld$getPlayerFromCapability(AptitudeCapability capability) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
                for (Player player : level.m_6907_()) {
                    LazyOptional cap = player.getCapability(RegistryCapabilities.APTITUDE);
                    if (cap == null || !cap.resolve().isPresent() || cap.resolve().get() != capability) continue;
                    return player;
                }
            }
        }
        return null;
    }
}

