/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.mixin;

import dev.muon.otherworldorigins.mixin.MobEffectInstanceAccessor;
import dev.muon.otherworldorigins.power.ModPowers;
import dev.muon.otherworldorigins.power.ModifyStatusEffectCategoryPower;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;)Z"}, at={@At(value="HEAD")})
    private void onAddEffectNoEntity(MobEffectInstance effect, CallbackInfoReturnable<Boolean> cir) {
        this.otherworld$modifyEffectDuration(effect, null);
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")})
    private void onAddEffectWithEntity(MobEffectInstance effect, Entity source, CallbackInfoReturnable<Boolean> cir) {
        this.otherworld$modifyEffectDuration(effect, source);
    }

    @Unique
    private void otherworld$modifyEffectDuration(MobEffectInstance effect, Entity source) {
        LivingEntity self = (LivingEntity)this;
        float multiplier = LivingEntityMixin.otherworld$getEffectMultiplier(self, effect);
        if (multiplier != 1.0f) {
            int newDuration = Math.round((float)effect.m_19557_() * multiplier);
            ((MobEffectInstanceAccessor)effect).setDuration(newDuration);
        }
    }

    @Unique
    private static float otherworld$getEffectMultiplier(LivingEntity entity, MobEffectInstance effect) {
        IPowerContainer powerContainer = ApoliAPI.getPowerContainer((Entity)entity);
        if (powerContainer != null) {
            return powerContainer.getPowers((PowerFactory)ModPowers.MODIFY_STATUS_EFFECT_CATEGORY.get()).stream().filter(holder -> ModifyStatusEffectCategoryPower.doesApply((ModifyStatusEffectCategoryPower.Configuration)((ConfiguredPower)holder.m_203334_()).getConfiguration(), effect.m_19544_())).map(holder -> Float.valueOf(((ModifyStatusEffectCategoryPower.Configuration)((ConfiguredPower)holder.m_203334_()).getConfiguration()).amount())).reduce(Float.valueOf(1.0f), (a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).floatValue();
        }
        return 1.0f;
    }
}

