/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.seniors.justlevelingfork.registry.skills.Skill;
import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.condition.ModConditions;
import dev.muon.otherworldorigins.power.GoldDurabilityPower;
import dev.muon.otherworldorigins.power.ModPowers;
import dev.muon.otherworldorigins.restrictions.EnchantmentRestrictions;
import dev.muon.otherworldorigins.restrictions.SpellRestrictions;
import dev.muon.otherworldorigins.skills.ModSkills;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.configuration.NoConfiguration;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.condition.item.SimpleItemCondition;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellSlot;
import io.redspace.ironsspellbooks.item.Scroll;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Unique
    private static final TagKey<Item> GOLDEN_GEAR = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)OtherworldOrigins.loc("golden_gear"));

    @Unique
    private AbstractSpell otherworld$getSpellFromScroll(ItemStack itemStack) {
        return ISpellContainer.get((ItemStack)itemStack).getSpellAtIndex(0).getSpell();
    }

    @ModifyReturnValue(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private List<Component> modifyTooltips(List<Component> original, Player player, TooltipFlag isAdvanced) {
        if (player == null) {
            return original;
        }
        ItemStack stack = (ItemStack)this;
        ArrayList<Component> modifiedTooltips = new ArrayList<Component>(original);
        this.otherworld$addEnchantmentTooltips(modifiedTooltips, stack, player);
        this.otherworld$addSpellTooltips(modifiedTooltips, stack, player);
        this.otherworld$addReforgeTableTooltips(modifiedTooltips, stack, player);
        return modifiedTooltips;
    }

    @Unique
    private void otherworld$addReforgeTableTooltips(List<Component> tooltips, ItemStack stack, Player player) {
        Block block = Block.m_49814_((Item)stack.m_41720_());
        boolean isAdvancedTable = block.m_49966_().m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)OtherworldOrigins.loc("advanced_tables")));
        boolean isBasicTable = block.m_49966_().m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)OtherworldOrigins.loc("basic_tables")));
        if (isAdvancedTable || isBasicTable) {
            boolean hasSkill = ((Skill)ModSkills.REFORGING.get()).isEnabled(player);
            boolean isUnderdarkRace = this.otherworld$isUnderdarkRace(player);
            if (!(!isAdvancedTable || hasSkill && isUnderdarkRace)) {
                tooltips.set(0, (Component)Component.m_237113_((String)"").m_7220_(tooltips.get(0)).m_130940_(ChatFormatting.STRIKETHROUGH));
                tooltips.add(1, (Component)Component.m_237115_((String)"otherworldorigins.tooltip.advanced_table_restricted").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            } else if (isBasicTable && !hasSkill && !isUnderdarkRace) {
                tooltips.set(0, (Component)Component.m_237113_((String)"").m_7220_(tooltips.get(0)).m_130940_(ChatFormatting.STRIKETHROUGH));
                tooltips.add(1, (Component)Component.m_237115_((String)"otherworldorigins.tooltip.basic_table_restricted").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
        }
    }

    @Unique
    private void otherworld$addEnchantmentTooltips(List<Component> tooltips, ItemStack stack, Player player) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        block0: for (int i = 0; i < tooltips.size(); ++i) {
            Component line = tooltips.get(i);
            for (Map.Entry entry : enchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                if (!line.getString().contains(enchantment.m_44700_(((Integer)entry.getValue()).intValue()).getString()) || EnchantmentRestrictions.isEnchantmentAllowed(player, enchantment)) continue;
                MutableComponent disabledLine = Component.m_237113_((String)"").m_7220_(line).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.STRIKETHROUGH});
                tooltips.set(i, (Component)disabledLine);
                String requiredClass = EnchantmentRestrictions.getRequiredClass(enchantment);
                if (requiredClass == null) continue block0;
                String className = requiredClass.substring(0, 1).toUpperCase() + requiredClass.substring(1);
                MutableComponent explanationLine = Component.m_237113_((String)("Only " + className + "s can use this enchantment")).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});
                tooltips.add(i + 1, (Component)explanationLine);
                continue block0;
            }
        }
    }

    @Unique
    private void otherworld$addSpellTooltips(List<Component> tooltips, ItemStack stack, Player player) {
        if (stack.m_41720_() instanceof Scroll) {
            AbstractSpell spell = this.otherworld$getSpellFromScroll(stack);
            if (spell != null && !SpellRestrictions.isSpellAllowed(player, spell)) {
                MutableComponent warningText = Component.m_237113_((String)"Can only be cast using a Scroll - ").m_7220_(SpellRestrictions.getRestrictionMessage(player, spell)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC});
                tooltips.add(1, (Component)warningText);
            }
        } else if (ISpellContainer.isSpellContainer((ItemStack)stack)) {
            ISpellContainer spellContainer = ISpellContainer.get((ItemStack)stack);
            block0: for (int i = 0; i < tooltips.size(); ++i) {
                Component line = tooltips.get(i);
                for (SpellSlot spellData : spellContainer.getActiveSpells()) {
                    AbstractSpell spell = spellData.getSpell();
                    String spellName = spell.getDisplayName(null).getString();
                    if (!line.getString().contains(spellName) || SpellRestrictions.isSpellAllowed(player, spell)) continue;
                    MutableComponent disabledLine = Component.m_237113_((String)"").m_7220_(line).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.STRIKETHROUGH});
                    tooltips.set(i, (Component)disabledLine);
                    Component restrictionMessage = SpellRestrictions.getRestrictionMessage(player, spell);
                    MutableComponent restrictionText = Component.m_237113_((String)" ").m_7220_(restrictionMessage).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});
                    tooltips.add(i + 1, (Component)restrictionText);
                    continue block0;
                }
            }
        }
    }

    @Unique
    private boolean otherworld$isUnderdarkRace(Player player) {
        return IOriginContainer.get((Entity)player).resolve().map(container -> {
            ResourceLocation subraceLayerLoc = OtherworldOrigins.loc("subrace");
            ResourceKey playerOrigin = container.getOrigin(ResourceKey.m_135785_((ResourceKey)OriginsAPI.getLayersRegistry().m_123023_(), (ResourceLocation)subraceLayerLoc));
            if (playerOrigin == null) {
                return false;
            }
            String path = playerOrigin.m_135782_().m_135815_();
            return path.contains("drow") || path.contains("deep") || path.contains("duergar");
        }).orElse(false);
    }

    @WrapOperation(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getItemEnchantmentLevel(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/item/ItemStack;)I")})
    private int otherworldorigins$addUnbreaking(Enchantment enchantment, ItemStack stack, Operation<Integer> original, int pAmount, RandomSource pRandom, ServerPlayer pUser) {
        IPowerContainer powerContainer;
        int level = (Integer)original.call(new Object[]{enchantment, stack});
        if (enchantment == Enchantments.f_44986_ && pUser != null && this.otherworld$isGoldenGear(pUser.m_9236_(), stack) && (powerContainer = ApoliAPI.getPowerContainer((Entity)pUser)) != null) {
            List playerPowers = powerContainer.getPowers((PowerFactory)ModPowers.GOLD_DURABILITY.get());
            int totalUnbreaking = playerPowers.stream().map(holder -> (GoldDurabilityPower.Configuration)((ConfiguredPower)holder.m_203334_()).getConfiguration()).mapToInt(GoldDurabilityPower.Configuration::amount).sum();
            level += totalUnbreaking;
        }
        return level;
    }

    @Unique
    private boolean otherworld$isGoldenGear(Level level, ItemStack stack) {
        return stack.m_204117_(GOLDEN_GEAR) || ((SimpleItemCondition)ModConditions.IS_GOLDEN_WEAPON.get()).check(NoConfiguration.INSTANCE, level, stack) || ((SimpleItemCondition)ModConditions.IS_GOLDEN_TOOL.get()).check(NoConfiguration.INSTANCE, level, stack) || ((SimpleItemCondition)ModConditions.IS_GOLDEN_ARMOR.get()).check(NoConfiguration.INSTANCE, level, stack);
    }
}

