/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.entity.summons;

import dev.muon.otherworldorigins.entity.ModEntities;
import dev.muon.otherworldorigins.spells.ModSpells;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericProtectOwnerTargetGoal;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SummonedIronGolem
extends IronGolem
implements IMagicSummon {
    protected LivingEntity cachedSummoner;
    protected UUID summonerUUID;
    private final Level level = this.m_9236_();

    public SummonedIronGolem(EntityType<? extends IronGolem> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 0;
    }

    public SummonedIronGolem(Level pLevel, LivingEntity owner) {
        this((EntityType<? extends IronGolem>)((EntityType)ModEntities.SUMMONED_IRON_GOLEM.get()), pLevel);
        this.setSummoner(owner);
    }

    public boolean m_6549_(EntityType<?> pType) {
        return true;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new IronGolemMeleeAttackGoal());
        this.f_21345_.m_25352_(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, (double)0.9f, 15.0f, 5.0f, false, 25.0f));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, this::getSummoner));
        this.f_21346_.m_25352_(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new GenericProtectOwnerTargetGoal((Mob)this, this::getSummoner));
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (this.m_20160_()) {
            return super.m_6071_(pPlayer, pHand);
        }
        if (pPlayer == this.getSummoner()) {
            this.doPlayerRide(pPlayer);
        }
        return InteractionResult.m_19078_((boolean)this.level.f_46443_);
    }

    protected void doPlayerRide(Player pPlayer) {
        if (!this.level.f_46443_) {
            pPlayer.m_146922_(this.m_146908_());
            pPlayer.m_146926_(this.m_146909_());
            pPlayer.m_20329_((Entity)this);
        }
    }

    public LivingEntity getSummoner() {
        return OwnerHelper.getAndCacheOwner((Level)this.level, (LivingEntity)this.cachedSummoner, (UUID)this.summonerUUID);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.m_20148_();
            this.cachedSummoner = owner;
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.m_6667_(pDamageSource);
    }

    public void onRemovedFromWorld() {
        this.onRemovedHelper((Entity)this);
        super.onRemovedFromWorld();
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
    }

    public boolean m_7327_(Entity pEntity) {
        return Utils.doMeleeAttack((Mob)this, (Entity)pEntity, (DamageSource)((AbstractSpell)ModSpells.SUMMON_IRON_GOLEM.get()).getDamageSource((Entity)this, (Entity)this.getSummoner()));
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || this.isAlliedHelper(pEntity);
    }

    public void onUnSummon() {
        if (!this.level.f_46443_) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)ParticleTypes.f_123759_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            this.m_142467_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.shouldIgnoreDamage(pSource)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public static AttributeSupplier.Builder m_28883_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 8.0);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            return (Mob)entity;
        }
        entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.f_19859_ = this.m_146908_();
        this.m_146922_(player.m_146908_());
        this.m_146926_(player.m_146909_());
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20883_ = this.f_19859_;
        this.f_20885_ = this.m_146908_();
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        float f = player.f_20900_ * 0.5f;
        float f1 = player.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        if (this.m_20069_()) {
            f *= 0.3f;
            f1 *= 0.3f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    protected float m_245547_(@NotNull Player player) {
        return (float)this.m_21133_(Attributes.f_22279_) * 0.8f;
    }

    class IronGolemMeleeAttackGoal
    extends MeleeAttackGoal {
        public IronGolemMeleeAttackGoal() {
            super((PathfinderMob)SummonedIronGolem.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)pEnemy);
            } else if (pDistToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    // empty if block
                }
            } else {
                this.m_25563_();
            }
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }
}

