/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.condition;

import dev.muon.otherworldorigins.condition.entity.AnyOnLayerCondition;
import dev.muon.otherworldorigins.condition.entity.HasSkillCondition;
import dev.muon.otherworldorigins.condition.entity.ManaCondition;
import dev.muon.otherworldorigins.condition.entity.PlayerLevelCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.BiEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.BlockCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityCondition;
import io.github.edwinmindcraft.apoli.api.power.factory.ItemCondition;
import io.github.edwinmindcraft.apoli.api.registry.ApoliRegistries;
import io.github.edwinmindcraft.apoli.common.condition.bientity.SimpleBiEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.entity.SimpleEntityCondition;
import io.github.edwinmindcraft.apoli.common.condition.item.SimpleItemCondition;
import io.redspace.ironsspellbooks.item.CastingItem;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModConditions {
    public static final DeferredRegister<EntityCondition<?>> ENTITY_CONDITIONS = DeferredRegister.create((ResourceKey)ApoliRegistries.ENTITY_CONDITION_KEY, (String)"otherworldorigins");
    public static final DeferredRegister<BiEntityCondition<?>> BIENTITY_CONDITIONS = DeferredRegister.create((ResourceKey)ApoliRegistries.BIENTITY_CONDITION_KEY, (String)"otherworldorigins");
    public static final DeferredRegister<BlockCondition<?>> BLOCK_CONDITIONS = DeferredRegister.create((ResourceKey)ApoliRegistries.BLOCK_CONDITION_KEY, (String)"otherworldorigins");
    public static final DeferredRegister<ItemCondition<?>> ITEM_CONDITIONS = DeferredRegister.create((ResourceKey)ApoliRegistries.ITEM_CONDITION_KEY, (String)"otherworldorigins");
    public static final RegistryObject<SimpleEntityCondition> IS_ARROW = ENTITY_CONDITIONS.register("is_arrow", () -> new SimpleEntityCondition(entity -> entity instanceof AbstractArrow));
    public static final RegistryObject<SimpleEntityCondition> CREATIVE_MODE = ENTITY_CONDITIONS.register("creative_mode", () -> new SimpleEntityCondition(entity -> {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!player.m_150110_().f_35937_) return false;
        return true;
    }));
    public static final RegistryObject<PlayerLevelCondition> PLAYER_LEVEL = ENTITY_CONDITIONS.register("player_level", PlayerLevelCondition::new);
    public static final RegistryObject<AnyOnLayerCondition> ANY_ON_LAYER = ENTITY_CONDITIONS.register("any_on_layer", AnyOnLayerCondition::new);
    public static final RegistryObject<ManaCondition> PLAYER_MANA = ENTITY_CONDITIONS.register("player_mana", ManaCondition::new);
    public static final RegistryObject<HasSkillCondition> HAS_SKILL = ENTITY_CONDITIONS.register("has_skill", HasSkillCondition::new);
    public static final RegistryObject<SimpleBiEntityCondition> IS_ALLIED = BIENTITY_CONDITIONS.register("allied", () -> new SimpleBiEntityCondition((actor, target) -> actor.m_7307_(target)));
    public static final RegistryObject<SimpleItemCondition> IS_MELEE_WEAPON = ITEM_CONDITIONS.register("is_melee_weapon", () -> new SimpleItemCondition(stack -> Enchantments.f_44977_.m_6081_(stack) || stack.m_41720_() instanceof DiggerItem && ((DiggerItem)stack.m_41720_()).m_41008_() > 0.0f));
    public static final RegistryObject<SimpleItemCondition> IS_BOW = ITEM_CONDITIONS.register("is_bow", () -> new SimpleItemCondition(stack -> stack.m_41720_() instanceof BowItem));
    public static final RegistryObject<SimpleItemCondition> IS_ONE_HANDED = ITEM_CONDITIONS.register("is_one_handed", () -> new SimpleItemCondition(stack -> {
        if (ModList.get().isLoaded("bettercombat")) {
            WeaponAttributes weaponAttributes = WeaponRegistry.getAttributes((ItemStack)stack);
            return weaponAttributes != null && !weaponAttributes.isTwoHanded();
        }
        return true;
    }));
    public static final RegistryObject<SimpleItemCondition> IS_TWO_HANDED = ITEM_CONDITIONS.register("is_two_handed", () -> new SimpleItemCondition(stack -> {
        if (ModList.get().isLoaded("bettercombat")) {
            WeaponAttributes weaponAttributes = WeaponRegistry.getAttributes((ItemStack)stack);
            return weaponAttributes != null && weaponAttributes.isTwoHanded();
        }
        return false;
    }));
    public static final RegistryObject<SimpleItemCondition> CAN_CAST = ITEM_CONDITIONS.register("can_cast", () -> new SimpleItemCondition(stack -> stack.m_41720_() instanceof CastingItem));
    public static final RegistryObject<SimpleItemCondition> IS_SWORD = ITEM_CONDITIONS.register("is_sword", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return (stack.m_41720_() instanceof SwordItem || Enchantments.f_44977_.m_6081_(stack)) && itemName.contains("sword");
    }));
    public static final RegistryObject<SimpleItemCondition> IS_STAFF = ITEM_CONDITIONS.register("is_staff", () -> new SimpleItemCondition(stack -> ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_().contains("staff")));
    public static final RegistryObject<SimpleItemCondition> IS_FIST_WEAPON = ITEM_CONDITIONS.register("is_fist_weapon", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return !(!(stack.m_41720_() instanceof SwordItem) && !Enchantments.f_44977_.m_6081_(stack) || !itemName.contains("fist") && !itemName.contains("claw") && !itemName.contains("gauntlet"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_TOOL = ITEM_CONDITIONS.register("is_tool", () -> new SimpleItemCondition(stack -> stack.m_41720_() instanceof DiggerItem || Enchantments.f_44984_.m_6081_(stack)));
    public static final RegistryObject<SimpleItemCondition> IS_GOLDEN_ARMOR = ITEM_CONDITIONS.register("is_golden_armor", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return stack.m_41720_() instanceof ArmorItem && (itemName.contains("gold") || itemName.contains("gilded"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_GOLDEN_WEAPON = ITEM_CONDITIONS.register("is_golden_weapon", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return Enchantments.f_44977_.m_6081_(stack) && (itemName.contains("gold") || itemName.contains("gilded"));
    }));
    public static final RegistryObject<SimpleItemCondition> IS_GOLDEN_TOOL = ITEM_CONDITIONS.register("is_golden_tool", () -> new SimpleItemCondition(stack -> {
        String itemName = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        return stack.m_41720_() instanceof DiggerItem && (itemName.contains("gold") || itemName.contains("gilded"));
    }));

    public static void register(IEventBus eventBus) {
        ENTITY_CONDITIONS.register(eventBus);
        BIENTITY_CONDITIONS.register(eventBus);
        BLOCK_CONDITIONS.register(eventBus);
        ITEM_CONDITIONS.register(eventBus);
    }
}

