/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.restrictions.SpellCategory;
import dev.muon.otherworldorigins.restrictions.SpellCategoryMapper;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="otherworldorigins", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModCommands {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"otherworldorigins").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dumpSpells").requires(source -> source.m_6761_(2))).executes(context -> ModCommands.dumpSpells((CommandSourceStack)context.getSource()))));
    }

    private static int dumpSpells(CommandSourceStack source) {
        SpellCategoryMapper.initialize();
        Collection spells = ((IForgeRegistry)SpellRegistry.REGISTRY.get()).getValues();
        ArrayList<SpellData> spellDataList = new ArrayList<SpellData>();
        for (AbstractSpell spell : spells) {
            if (spell == SpellRegistry.none()) continue;
            String spellId = spell.getSpellId();
            Set<SpellCategory> categories = SpellCategoryMapper.getCategories(spell);
            String categoryString = categories.stream().map(Enum::name).reduce((a, b) -> a + "," + b).orElse("UNKNOWN");
            SchoolType school = spell.getSchoolType();
            String schoolName = school.getId().toString();
            int minRarityInt = spell.getMinRarity();
            SpellRarity minRarity = SpellRarity.values()[minRarityInt];
            spellDataList.add(new SpellData(spellId, categoryString, schoolName, minRarity.name()));
        }
        try {
            Path configDir = FMLPaths.CONFIGDIR.get();
            Path modConfigDir = configDir.resolve("otherworldorigins");
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
            Path outputFile = modConfigDir.resolve("spells.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(spellDataList);
            Files.writeString(outputFile, (CharSequence)json, new OpenOption[0]);
            source.m_288197_(() -> Component.m_237113_((String)("Spell dump complete! Written to: " + String.valueOf(outputFile))), true);
            OtherworldOrigins.LOGGER.info("Spell dump written to: {}", (Object)outputFile);
            return spellDataList.size();
        }
        catch (IOException e) {
            OtherworldOrigins.LOGGER.error("Failed to write spell dump to file", (Throwable)e);
            source.m_81352_((Component)Component.m_237113_((String)("Failed to write spell dump: " + e.getMessage())));
            return 0;
        }
    }

    private static class SpellData {
        private final String spellId;
        private final String category;
        private final String school;
        private final String minRarity;

        public SpellData(String spellId, String category, String school, String minRarity) {
            this.spellId = spellId;
            this.category = category;
            this.school = school;
            this.minRarity = minRarity;
        }

        public String getSpellId() {
            return this.spellId;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSchool() {
            return this.school;
        }

        public String getMinRarity() {
            return this.minRarity;
        }
    }
}

