/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.client.screen;

import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.network.GiveStarterKitMessage;
import dev.muon.otherworldorigins.network.ResetOriginsMessage;
import dev.muon.otherworldorigins.util.ClientLayerScreenHelper;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FinalConfirmScreen
extends Screen {
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 20;
    private static final int PADDING = 5;
    private static final int LINE_HEIGHT = 14;
    private static final ResourceLocation CHARACTER_SHEET = OtherworldOrigins.loc("textures/gui/character_sheet.png");
    private static final int SHEET_WIDTH = 256;
    private static final int SHEET_HEIGHT = 256;
    private static final int TEXT_WIDTH = 190;
    private List<FormattedCharSequence> displayLines = new ArrayList<FormattedCharSequence>();
    private Set<Integer> headerLineIndices = new HashSet<Integer>();

    public FinalConfirmScreen() {
        super((Component)Component.m_237115_((String)"otherworldorigins.gui.final_confirm.title"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buildDisplayLines();
        int centerX = this.f_96543_ / 2;
        int sheetY = (this.f_96544_ - 256) / 2;
        int defaultButtonY = sheetY + 256 + 5;
        int buttonY = defaultButtonY + 20 + 5 <= this.f_96544_ ? defaultButtonY : this.f_96544_ - 20 - 10;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"otherworldorigins.gui.final_confirm.confirm"), button -> {
            OtherworldOrigins.CHANNEL.sendToServer((Object)new GiveStarterKitMessage());
            ClientLayerScreenHelper.clearSelectedLayers();
            this.m_7379_();
        }).m_252987_(centerX - 100 - 5 + 2, buttonY, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"otherworldorigins.gui.final_confirm.start_over"), button -> {
            ClientLayerScreenHelper.clearSelectedLayers();
            OtherworldOrigins.CHANNEL.sendToServer((Object)new ResetOriginsMessage());
            this.m_7379_();
        }).m_252987_(centerX + 5 + 2, buttonY, 100, 20).m_253136_());
    }

    private void buildDisplayLines() {
        List<Component> aptitudes;
        List<String> cantrips;
        List<String> featNames;
        this.displayLines.clear();
        this.headerLineIndices.clear();
        IOriginContainer originContainer = IOriginContainer.get((Entity)this.f_96541_.f_91074_).resolve().orElse(null);
        if (originContainer == null) {
            return;
        }
        MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry(null);
        MappedRegistry originRegistry = OriginsAPI.getOriginsRegistry(null);
        MutableComponent playerName = this.f_96541_.f_91074_.m_7755_().m_6881_().m_130940_(ChatFormatting.ITALIC);
        String race = this.getOriginDisplayName(originContainer, (Registry<OriginLayer>)layerRegistry, (Registry<Origin>)originRegistry, OtherworldOrigins.loc("race"));
        String subrace = this.getOriginDisplayName(originContainer, (Registry<OriginLayer>)layerRegistry, (Registry<Origin>)originRegistry, OtherworldOrigins.loc("subrace"));
        String className = this.getOriginDisplayName(originContainer, (Registry<OriginLayer>)layerRegistry, (Registry<Origin>)originRegistry, OtherworldOrigins.loc("class"));
        String subclassName = this.getOriginDisplayName(originContainer, (Registry<OriginLayer>)layerRegistry, (Registry<Origin>)originRegistry, OtherworldOrigins.loc("subclass"));
        if (subrace != null && race != null && subrace.endsWith(" " + race)) {
            subrace = subrace.substring(0, subrace.length() - race.length() - 1);
        }
        if (race != null && className != null) {
            MutableComponent mainText;
            MutableComponent raceClassHeader = Component.m_237115_((String)"otherworldorigins.gui.final_confirm.race_class_header").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)));
            this.addWrappedTextAsHeader((Component)raceClassHeader);
            boolean useAn = false;
            if (subclassName != null && !subclassName.isEmpty()) {
                char firstChar = Character.toLowerCase(subclassName.charAt(0));
                boolean bl = useAn = firstChar == 'a' || firstChar == 'e' || firstChar == 'i' || firstChar == 'o' || firstChar == 'u';
            }
            if (race.equals("Other") || race.equals("Undead")) {
                if (subrace != null && !subrace.isEmpty()) {
                    key = useAn ? "otherworldorigins.gui.final_confirm.main_description_no_race_an" : "otherworldorigins.gui.final_confirm.main_description_no_race";
                    mainText = Component.m_237110_((String)key, (Object[])new Object[]{playerName, subclassName != null ? subclassName : "", className, subrace});
                } else {
                    key = useAn ? "otherworldorigins.gui.final_confirm.main_description_simple_an" : "otherworldorigins.gui.final_confirm.main_description_simple";
                    mainText = Component.m_237110_((String)key, (Object[])new Object[]{playerName, subclassName != null ? subclassName : "", className});
                }
            } else {
                key = useAn ? "otherworldorigins.gui.final_confirm.main_description_an" : "otherworldorigins.gui.final_confirm.main_description";
                mainText = Component.m_237110_((String)key, (Object[])new Object[]{playerName, subclassName != null ? subclassName : "", className, subrace != null ? subrace : "", race});
            }
            this.addWrappedText((Component)mainText);
            this.displayLines.add(FormattedCharSequence.f_13691_);
        }
        if (!(featNames = this.getFeats(originContainer, (Registry<OriginLayer>)layerRegistry, (Registry<Origin>)originRegistry)).isEmpty()) {
            MutableComponent featsHeader = Component.m_237115_((String)"otherworldorigins.gui.final_confirm.feats_header").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)));
            this.addWrappedTextAsHeader((Component)featsHeader);
            Component featsText = this.formatFeatsList(featNames);
            this.addWrappedText(featsText);
            this.displayLines.add(FormattedCharSequence.f_13691_);
        }
        if (!(cantrips = this.getCantrips(originContainer, (Registry<OriginLayer>)layerRegistry, (Registry<Origin>)originRegistry)).isEmpty()) {
            MutableComponent cantripsHeader = Component.m_237115_((String)"otherworldorigins.gui.final_confirm.cantrips_header").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)));
            this.addWrappedTextAsHeader((Component)cantripsHeader);
            Component cantripText = this.formatCantripsList(cantrips);
            this.addWrappedText(cantripText);
            this.displayLines.add(FormattedCharSequence.f_13691_);
        }
        if (!(aptitudes = this.getAptitudeBonuses(originContainer, (Registry<OriginLayer>)layerRegistry, (Registry<Origin>)originRegistry)).isEmpty()) {
            MutableComponent aptitudesHeader = Component.m_237115_((String)"otherworldorigins.gui.final_confirm.aptitudes_header").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)));
            this.addWrappedTextAsHeader((Component)aptitudesHeader);
            for (Component aptitude : aptitudes) {
                this.addWrappedText(aptitude);
            }
        }
    }

    private void addWrappedText(Component text) {
        List wrapped = this.f_96547_.m_92923_((FormattedText)text, 190);
        this.displayLines.addAll(wrapped);
    }

    private void addWrappedTextAsHeader(Component text) {
        int startIndex = this.displayLines.size();
        List wrapped = this.f_96547_.m_92923_((FormattedText)text, 190);
        this.displayLines.addAll(wrapped);
        for (int i = startIndex; i < this.displayLines.size(); ++i) {
            this.headerLineIndices.add(i);
        }
    }

    private String getOriginDisplayName(IOriginContainer container, Registry<OriginLayer> layerRegistry, Registry<Origin> originRegistry, ResourceLocation layerId) {
        Holder origin;
        ResourceKey originKey;
        ResourceKey layerKey = ResourceKey.m_135785_((ResourceKey)layerRegistry.m_123023_(), (ResourceLocation)layerId);
        Holder layer = layerRegistry.m_203636_(layerKey).orElse(null);
        if (layer != null && (originKey = container.getOrigin(layer)) != null && !originKey.m_135782_().equals((Object)new ResourceLocation("origins", "empty")) && (origin = (Holder)originRegistry.m_203636_(originKey).orElse(null)) != null) {
            return ((Origin)origin.m_203334_()).getName().getString();
        }
        return null;
    }

    private List<String> getFeats(IOriginContainer container, Registry<OriginLayer> layerRegistry, Registry<Origin> originRegistry) {
        ResourceLocation[] featLayerIds;
        ArrayList<String> feats = new ArrayList<String>();
        for (ResourceLocation layerId : featLayerIds = new ResourceLocation[]{OtherworldOrigins.loc("free_feat"), OtherworldOrigins.loc("first_feat"), OtherworldOrigins.loc("second_feat"), OtherworldOrigins.loc("third_feat"), OtherworldOrigins.loc("fourth_feat"), OtherworldOrigins.loc("fifth_feat")}) {
            String featName = this.getOriginDisplayName(container, layerRegistry, originRegistry, layerId);
            if (featName == null) continue;
            feats.add(featName);
        }
        return feats;
    }

    private Component formatFeatsList(List<String> feats) {
        if (feats.isEmpty()) {
            return Component.m_237119_();
        }
        if (feats.size() == 1) {
            return Component.m_237110_((String)"otherworldorigins.gui.final_confirm.feats_single", (Object[])new Object[]{feats.get(0)});
        }
        if (feats.size() == 2) {
            return Component.m_237110_((String)"otherworldorigins.gui.final_confirm.feats_double", (Object[])new Object[]{feats.get(0), feats.get(1)});
        }
        String allButLast = String.join((CharSequence)", ", feats.subList(0, feats.size() - 1));
        return Component.m_237110_((String)"otherworldorigins.gui.final_confirm.feats_multiple", (Object[])new Object[]{allButLast, feats.get(feats.size() - 1)});
    }

    private List<String> getCantrips(IOriginContainer container, Registry<OriginLayer> layerRegistry, Registry<Origin> originRegistry) {
        ArrayList<String> cantrips = new ArrayList<String>();
        String cantrip1 = this.getOriginDisplayName(container, layerRegistry, originRegistry, OtherworldOrigins.loc("cantrip_one"));
        String cantrip2 = this.getOriginDisplayName(container, layerRegistry, originRegistry, OtherworldOrigins.loc("cantrip_two"));
        if (cantrip1 != null) {
            cantrips.add(cantrip1);
        }
        if (cantrip2 != null) {
            cantrips.add(cantrip2);
        }
        return cantrips;
    }

    private Component formatCantripsList(List<String> cantrips) {
        if (cantrips.isEmpty()) {
            return Component.m_237119_();
        }
        if (cantrips.size() == 1) {
            return Component.m_237110_((String)"otherworldorigins.gui.final_confirm.cantrips_single", (Object[])new Object[]{cantrips.get(0)});
        }
        return Component.m_237110_((String)"otherworldorigins.gui.final_confirm.cantrips_double", (Object[])new Object[]{cantrips.get(0), cantrips.get(1)});
    }

    private List<Component> getAptitudeBonuses(IOriginContainer container, Registry<OriginLayer> layerRegistry, Registry<Origin> originRegistry) {
        ArrayList<Component> aptitudes = new ArrayList<Component>();
        String plusOne1 = this.getOriginDisplayName(container, layerRegistry, originRegistry, OtherworldOrigins.loc("plus_one_aptitude_one"));
        String plusOne2 = this.getOriginDisplayName(container, layerRegistry, originRegistry, OtherworldOrigins.loc("plus_one_aptitude_two"));
        String plusOneResilient = this.getOriginDisplayName(container, layerRegistry, originRegistry, OtherworldOrigins.loc("plus_one_aptitude_resilient"));
        String plusTwo1 = this.getOriginDisplayName(container, layerRegistry, originRegistry, OtherworldOrigins.loc("plus_two_aptitude_one"));
        String plusTwo2 = this.getOriginDisplayName(container, layerRegistry, originRegistry, OtherworldOrigins.loc("plus_two_aptitude_two"));
        ArrayList<String> plusOnes = new ArrayList<String>();
        ArrayList<String> plusTwos = new ArrayList<String>();
        if (plusOne1 != null) {
            plusOnes.add(plusOne1);
        }
        if (plusOne2 != null) {
            plusOnes.add(plusOne2);
        }
        if (plusOneResilient != null) {
            plusOnes.add(plusOneResilient);
        }
        if (plusTwo1 != null) {
            plusTwos.add(plusTwo1);
        }
        if (plusTwo2 != null) {
            plusTwos.add(plusTwo2);
        }
        if (!plusTwos.isEmpty()) {
            aptitudes.add((Component)Component.m_237110_((String)"otherworldorigins.gui.final_confirm.aptitude_plus_two", (Object[])new Object[]{String.join((CharSequence)", ", plusTwos)}));
        }
        if (!plusOnes.isEmpty()) {
            aptitudes.add((Component)Component.m_237110_((String)"otherworldorigins.gui.final_confirm.aptitude_plus_one", (Object[])new Object[]{String.join((CharSequence)", ", plusOnes)}));
        }
        return aptitudes;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int textStartY;
        this.m_280273_(graphics);
        int sheetX = (this.f_96543_ - 256) / 2;
        int sheetY = (this.f_96544_ - 256) / 2;
        graphics.m_280163_(CHARACTER_SHEET, sheetX, sheetY, 0.0f, 0.0f, 256, 256, 256, 256);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, sheetY - 20, 0xFFFFFF);
        int y = textStartY = sheetY + 40;
        int textX = sheetX + 33;
        for (int i = 0; i < this.displayLines.size(); ++i) {
            FormattedCharSequence line = this.displayLines.get(i);
            if (line == FormattedCharSequence.f_13691_) {
                y += 7;
                continue;
            }
            if (this.headerLineIndices.contains(i)) {
                int textWidth = this.f_96547_.m_92724_(line);
                int centeredX = sheetX + (256 - textWidth) / 2;
                graphics.m_280649_(this.f_96547_, line, centeredX, y, 0x3F3F3F, false);
            } else {
                graphics.m_280649_(this.f_96547_, line, textX, y, 0x3F3F3F, false);
            }
            y += 14;
        }
    }

    public boolean m_6913_() {
        return false;
    }
}

