/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.client.compat;

import com.github.exopandora.shouldersurfing.api.model.Couple;
import com.github.exopandora.shouldersurfing.api.model.PickContext;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;

public class ShoulderSurfingIntegration {
    private static final String SHOULDER_SURFING_MOD_ID = "shouldersurfing";
    private static Boolean isShoulderSurfingLoaded = null;

    private static boolean isShoulderSurfingLoaded() {
        if (isShoulderSurfingLoaded == null) {
            isShoulderSurfingLoaded = ModList.get().isLoaded(SHOULDER_SURFING_MOD_ID);
        }
        return isShoulderSurfingLoaded;
    }

    private static ShoulderSurfingImpl getShoulderSurfing() {
        if (!ShoulderSurfingIntegration.isShoulderSurfingLoaded()) {
            return null;
        }
        return ShoulderSurfingImpl.getInstance();
    }

    private static boolean isShoulderSurfing() {
        ShoulderSurfingImpl instance = ShoulderSurfingIntegration.getShoulderSurfing();
        return instance != null && instance.isShoulderSurfing();
    }

    public static void lookAtCrosshairTarget() {
        Vec3 targetLocation;
        Predicate<Entity> entityFilter;
        AABB searchBox;
        Vec3 entityEnd;
        Vec3 direction;
        Vec3 scaledEntityEnd;
        ShoulderSurfingImpl instance = ShoulderSurfingIntegration.getShoulderSurfing();
        if (instance == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        Camera camera = minecraft.f_91063_.m_109153_();
        double interactionRange = Config.CLIENT.getCrosshairType().isAimingDecoupled() ? 400.0 : Config.CLIENT.getCustomRaytraceDistance();
        PickContext pickContext = new PickContext.Builder(camera).build();
        Couple blockTrace = pickContext.blockTrace(interactionRange, 1.0f);
        Vec3 startPos = (Vec3)blockTrace.left();
        Vec3 endPos = (Vec3)blockTrace.right();
        HitResult blockHit = ShoulderSurfingIntegration.clipIgnoringPassableBlocks((BlockGetter)minecraft.f_91073_, startPos, endPos, (Entity)player);
        double blockDist = blockHit.m_6662_() != HitResult.Type.MISS ? startPos.m_82554_(blockHit.m_82450_()) : interactionRange;
        Couple entityTrace = pickContext.entityTrace(interactionRange, 1.0f);
        Vec3 entityStart = (Vec3)entityTrace.left();
        EntityHitResult entityHit = ProjectileUtil.m_37287_((Entity)player, (Vec3)entityStart, (Vec3)(scaledEntityEnd = entityStart.m_82549_((direction = (entityEnd = (Vec3)entityTrace.right()).m_82546_(entityStart).m_82541_()).m_82490_(blockDist))), (AABB)(searchBox = player.m_20191_().m_82369_(direction.m_82490_(blockDist)).m_82400_(1.0)), entityFilter = e -> !e.m_5833_() && e.m_6087_() && e != player, (double)(blockDist * blockDist));
        if (entityHit != null) {
            double entityDist = startPos.m_82554_(entityHit.m_82450_());
            targetLocation = blockHit.m_6662_() == HitResult.Type.MISS || entityDist < blockDist ? entityHit.m_82450_() : blockHit.m_82450_();
        } else {
            targetLocation = blockHit.m_82450_();
        }
        ShoulderSurfingIntegration.lookAtTarget(player, targetLocation);
        instance.getCamera().setLastMovedYRot(player.m_146908_());
    }

    private static HitResult clipIgnoringPassableBlocks(BlockGetter level, Vec3 start, Vec3 end, Entity entity) {
        return (HitResult)BlockGetter.m_151361_((Vec3)start, (Vec3)end, null, (context, blockPos) -> {
            BlockState blockState = level.m_8055_(blockPos);
            if (ShoulderSurfingIntegration.isPassableBlock(level, blockPos, blockState)) {
                return null;
            }
            VoxelShape shape = blockState.m_60812_(level, blockPos);
            if (shape.m_83281_()) {
                return null;
            }
            BlockHitResult hitResult = shape.m_83220_(start, end, blockPos);
            return hitResult;
        }, context -> {
            Vec3 direction = start.m_82546_(end);
            return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.m_122366_((double)direction.f_82479_, (double)direction.f_82480_, (double)direction.f_82481_), (BlockPos)BlockPos.m_274446_((Position)end));
        });
    }

    private static boolean isPassableBlock(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.m_60812_(level, pos).m_83281_()) {
            return true;
        }
        return state.m_60800_(level, pos) == 0.0f;
    }

    private static void lookAtTarget(LocalPlayer player, Vec3 target) {
        Vec3 eyePos = player.m_20299_(1.0f);
        double dx = target.f_82479_ - eyePos.f_82479_;
        double dy = target.f_82480_ - eyePos.f_82480_;
        double dz = target.f_82481_ - eyePos.f_82481_;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float yRot = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
        float xRot = (float)(-Math.toDegrees(Math.atan2(dy, horizontalDist)));
        player.m_146926_(xRot);
        player.m_146922_(yRot);
        ShoulderSurfingIntegration.syncRotationToServer(player);
    }

    private static void syncRotationToServer(LocalPlayer player) {
        if (player.f_108617_ != null) {
            player.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(player.m_146908_(), player.m_146909_(), player.m_20096_()));
        }
    }

    public static void lookAtCrosshairTargetIfShoulderSurfing() {
        if (ShoulderSurfingIntegration.isShoulderSurfing()) {
            ShoulderSurfingIntegration.lookAtCrosshairTarget();
        }
    }

    public static boolean shouldAimAtTarget() {
        return ShoulderSurfingIntegration.isCastingContinuousSpell();
    }

    private static boolean isContinuousSpell(CastType castType) {
        return castType == CastType.CONTINUOUS;
    }

    private static boolean isCastingContinuousSpell() {
        return ClientMagicData.isCasting() && ShoulderSurfingIntegration.isContinuousSpell(ClientMagicData.getCastType());
    }
}

