/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.attribute;

import dev.muon.otherworld.leveling.LevelingUtils;
import dev.muon.otherworld.leveling.event.AptitudeChangedEvent;
import dev.muon.otherworld.leveling.event.PassiveChangedEvent;
import dev.muon.otherworldorigins.attribute.ModAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherworldorigins")
public class HealthPerLevelHandler {
    private static final UUID HEALTH_PER_LEVEL_MODIFIER_UUID = UUID.fromString("a1b2c3d4-e5f6-7890-abcd-ef1234567890");
    private static final Map<Player, Integer> lastKnownLevels = new HashMap<Player, Integer>();
    private static final Map<Player, Double> lastKnownAttributeValues = new HashMap<Player, Double>();

    @SubscribeEvent
    public static void onAptitudeChanged(AptitudeChangedEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            HealthPerLevelHandler.updateHealthModifier((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onPassiveChanged(PassiveChangedEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            HealthPerLevelHandler.updateHealthModifier((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            HealthPerLevelHandler.updateHealthModifier((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            HealthPerLevelHandler.updateHealthModifier((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        lastKnownLevels.remove(player);
        lastKnownAttributeValues.remove(player);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            AttributeInstance healthPerLevelAttr;
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.f_19797_ % 20 == 0 && (healthPerLevelAttr = player2.m_21051_((Attribute)ModAttributes.HEALTH_PER_LEVEL.get())) != null) {
                int currentLevel = LevelingUtils.getPlayerLevel((Player)player2);
                double currentAttributeValue = healthPerLevelAttr.m_22135_();
                Integer lastLevel = lastKnownLevels.get(player2);
                Double lastAttributeValue = lastKnownAttributeValues.get(player2);
                if (lastLevel == null || lastLevel != currentLevel || lastAttributeValue == null || lastAttributeValue != currentAttributeValue) {
                    HealthPerLevelHandler.updateHealthModifier((Player)player2);
                }
            }
        }
    }

    public static void updateHealthModifier(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        AttributeInstance healthPerLevelAttr = player.m_21051_((Attribute)ModAttributes.HEALTH_PER_LEVEL.get());
        AttributeInstance maxHealthAttr = player.m_21051_(Attributes.f_22276_);
        if (healthPerLevelAttr == null || maxHealthAttr == null) {
            return;
        }
        float previousMaxHealth = player.m_21233_();
        float previousHealthPercent = previousMaxHealth > 0.0f ? player.m_21223_() / previousMaxHealth : 1.0f;
        maxHealthAttr.m_22120_(HEALTH_PER_LEVEL_MODIFIER_UUID);
        int characterLevel = LevelingUtils.getPlayerLevel((Player)player);
        double healthPerLevelValue = healthPerLevelAttr.m_22135_();
        double modifierValue = (double)characterLevel * healthPerLevelValue;
        lastKnownLevels.put(player, characterLevel);
        lastKnownAttributeValues.put(player, healthPerLevelValue);
        if (modifierValue > 0.0) {
            AttributeModifier modifier = new AttributeModifier(HEALTH_PER_LEVEL_MODIFIER_UUID, "Health per Character Level", modifierValue, AttributeModifier.Operation.ADDITION);
            maxHealthAttr.m_22118_(modifier);
            float newMaxHealth = player.m_21233_();
            if (newMaxHealth != previousMaxHealth && newMaxHealth > 0.0f) {
                player.m_21153_(newMaxHealth * previousHealthPercent);
            }
        }
    }
}

