/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.action.CastSpellAction;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.BiEntityAction;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.network.casting.CastErrorPacket;
import io.redspace.ironsspellbooks.network.casting.OnCastStartedPacket;
import io.redspace.ironsspellbooks.network.casting.OnClientCastPacket;
import io.redspace.ironsspellbooks.network.casting.SyncTargetingDataPacket;
import io.redspace.ironsspellbooks.network.casting.UpdateCastingStatePacket;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.eventbus.api.Event;

public class CastSpellBientityAction
extends BiEntityAction<Configuration> {
    public CastSpellBientityAction() {
        super(Configuration.CODEC);
    }

    public void execute(Configuration configuration, Entity actor, Entity target) {
        AbstractSpell spell;
        if (!(actor instanceof LivingEntity)) {
            OtherworldOrigins.LOGGER.debug("CastSpellBientityAction: Actor is not a LivingEntity: {}", (Object)actor);
            return;
        }
        LivingEntity caster = (LivingEntity)actor;
        if (!(target instanceof LivingEntity)) {
            OtherworldOrigins.LOGGER.debug("CastSpellBientityAction: Target is not a LivingEntity: {}", (Object)target);
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        String spellStr = configuration.spell().toString();
        ResourceLocation spellResourceLocation = ResourceLocation.m_135820_((String)spellStr);
        if (spellResourceLocation != null && spellResourceLocation.m_135827_().equals("minecraft")) {
            spellResourceLocation = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)spellResourceLocation.m_135815_());
        }
        if ((spell = SpellRegistry.getSpell((ResourceLocation)spellResourceLocation)) == null || "none".equals(spell.getSpellName())) {
            OtherworldOrigins.LOGGER.debug("CastSpellBientityAction: No valid spell found for resource location {}", (Object)spellResourceLocation);
            return;
        }
        Level world = actor.m_9236_();
        if (world.f_46443_) {
            return;
        }
        int powerLevel = configuration.powerLevel();
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        if (magicData.isCasting()) {
            OtherworldOrigins.LOGGER.debug("CastSpellBientityAction: Entity is still casting {}, forcing spell completion", (Object)magicData.getCastingSpellId());
            AbstractSpell oldSpell = magicData.getCastingSpell().getSpell();
            oldSpell.onCast(world, magicData.getCastingSpellLevel(), caster, magicData.getCastSource(), magicData);
            oldSpell.onServerCastComplete(world, magicData.getCastingSpellLevel(), caster, magicData, false);
            magicData.resetCastingState();
            magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        }
        OtherworldOrigins.LOGGER.debug("CastSpellBientityAction: Setting target to {}", (Object)livingTarget.m_7755_().getString());
        CastSpellBientityAction.updateTargetData(caster, (Entity)livingTarget, magicData, spell, e -> true);
        if (caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
            this.castSpellForPlayer(configuration, spell, powerLevel, serverPlayer, magicData, world);
        } else if (caster instanceof IMagicEntity) {
            IMagicEntity magicEntity = (IMagicEntity)caster;
            magicEntity.initiateCastSpell(spell, powerLevel);
        } else if (spell.checkPreCastConditions(world, powerLevel, caster, magicData)) {
            spell.onCast(world, powerLevel, caster, CastSource.COMMAND, magicData);
            spell.onServerCastComplete(world, powerLevel, caster, magicData, false);
        }
    }

    private void castSpellForPlayer(Configuration configuration, AbstractSpell spell, int powerLevel, ServerPlayer serverPlayer, MagicData magicData, Level world) {
        TargetEntityCastData targetingData;
        LivingEntity target;
        Optional<Integer> castTimeOpt = configuration.castTime();
        Optional<Integer> manaCostOpt = configuration.manaCost();
        CastResult castResult = spell.canBeCastedBy(powerLevel, CastSource.COMMAND, magicData, (Player)serverPlayer);
        if (castResult.message != null) {
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket(castResult.message));
        }
        if (!castResult.isSuccess() || !spell.checkPreCastConditions(world, powerLevel, (LivingEntity)serverPlayer, magicData) || MinecraftForge.EVENT_BUS.post((Event)new SpellPreCastEvent((Player)serverPlayer, spell.getSpellId(), powerLevel, spell.getSchoolType(), CastSource.COMMAND))) {
            return;
        }
        if (manaCostOpt.isPresent()) {
            int manaCost = manaCostOpt.get();
            if (!serverPlayer.m_150110_().f_35937_ && magicData.getMana() < (float)manaCost) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)CastErrorPacket.ErrorType.MANA);
                return;
            }
            if (!serverPlayer.m_150110_().f_35937_) {
                CastSpellBientityAction.setManaWithEvent(serverPlayer, magicData, magicData.getMana() - (float)manaCost);
            }
        }
        if (serverPlayer.m_6117_()) {
            serverPlayer.m_5810_();
        }
        int effectiveCastTime = castTimeOpt.isPresent() ? castTimeOpt.get() : (spell.getCastType() == CastType.CONTINUOUS ? spell.getEffectiveCastTime(powerLevel, (LivingEntity)serverPlayer) : (spell.getCastType() == CastType.INSTANT ? 0 : spell.getEffectiveCastTime(powerLevel, (LivingEntity)serverPlayer)));
        if (configuration.continuousCost() && manaCostOpt.isPresent() && !serverPlayer.m_150110_().f_35937_) {
            int manaCost = manaCostOpt.get();
            int costInterval = configuration.costInterval();
            CastSpellAction.registerContinuousCast(serverPlayer.m_20148_(), manaCost, costInterval);
        }
        magicData.initiateCast(spell, powerLevel, effectiveCastTime, CastSource.COMMAND, "command");
        magicData.setPlayerCastingItem(ItemStack.f_41583_);
        spell.onServerPreCast(world, powerLevel, (LivingEntity)serverPlayer, magicData);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new UpdateCastingStatePacket(spell.getSpellId(), powerLevel, effectiveCastTime, CastSource.COMMAND, "command"));
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (Object)new OnCastStartedPacket(serverPlayer.m_20148_(), spell.getSpellId(), powerLevel));
        ICastData costInterval = magicData.getAdditionalCastData();
        if (costInterval instanceof TargetEntityCastData && (target = (targetingData = (TargetEntityCastData)costInterval).getTarget((ServerLevel)serverPlayer.m_9236_())) != null) {
            OtherworldOrigins.LOGGER.debug("CastSpellBientityAction: Casting Spell {} with target {}", (Object)magicData.getCastingSpellId(), (Object)target.m_7755_().getString());
        }
        if (effectiveCastTime == 0) {
            spell.onCast(world, powerLevel, (LivingEntity)serverPlayer, CastSource.COMMAND, magicData);
            spell.onServerCastComplete(world, powerLevel, (LivingEntity)serverPlayer, magicData, false);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new OnClientCastPacket(spell.getSpellId(), powerLevel, CastSource.COMMAND, magicData.getAdditionalCastData()));
        }
    }

    private static void updateTargetData(LivingEntity caster, Entity entityHit, MagicData playerMagicData, AbstractSpell spell, Predicate<LivingEntity> filter) {
        LivingEntity livingParent;
        PartEntity partEntity;
        Entity entity;
        LivingEntity livingEntity;
        LivingEntity livingTarget = null;
        if (entityHit instanceof LivingEntity && filter.test(livingEntity = (LivingEntity)entityHit)) {
            livingTarget = livingEntity;
        } else if (entityHit instanceof PartEntity && (entity = (partEntity = (PartEntity)entityHit).getParent()) instanceof LivingEntity && filter.test(livingParent = (LivingEntity)entity)) {
            livingTarget = livingParent;
        }
        if (livingTarget != null) {
            playerMagicData.setAdditionalCastData((ICastData)new TargetEntityCastData(livingTarget));
            if (caster instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)caster;
                if (spell.getCastType() != CastType.INSTANT) {
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new SyncTargetingDataPacket(livingTarget, spell));
                }
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_success", (Object[])new Object[]{livingTarget.m_5446_().getString(), spell.getDisplayName((Player)serverPlayer)}).m_130940_(ChatFormatting.GREEN)));
            }
            if (livingTarget instanceof ServerPlayer) {
                ServerPlayer targetPlayer = (ServerPlayer)livingTarget;
                Utils.sendTargetedNotification((ServerPlayer)targetPlayer, (LivingEntity)caster, (AbstractSpell)spell);
            }
        }
    }

    private static void setManaWithEvent(ServerPlayer player, MagicData magicData, float newMana) {
        ChangeManaEvent event = new ChangeManaEvent((Player)player, magicData, magicData.getMana(), newMana);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            magicData.setMana(event.getNewMana());
        }
    }

    public static class Configuration
    implements IDynamicFeatureConfiguration {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.IDENTIFIER.fieldOf("spell").forGetter(Configuration::spell), (App)Codec.INT.optionalFieldOf("power_level", (Object)1).forGetter(Configuration::powerLevel), (App)Codec.INT.optionalFieldOf("cast_time").forGetter(Configuration::castTime), (App)Codec.INT.optionalFieldOf("mana_cost").forGetter(Configuration::manaCost), (App)Codec.BOOL.optionalFieldOf("continuous_cost", (Object)false).forGetter(Configuration::continuousCost), (App)Codec.INT.optionalFieldOf("cost_interval", (Object)20).forGetter(Configuration::costInterval)).apply((Applicative)instance, Configuration::new));
        private final ResourceLocation spell;
        private final int powerLevel;
        private final Optional<Integer> castTime;
        private final Optional<Integer> manaCost;
        private final boolean continuousCost;
        private final int costInterval;

        public Configuration(ResourceLocation spell, int powerLevel, Optional<Integer> castTime, Optional<Integer> manaCost, boolean continuousCost, int costInterval) {
            this.spell = spell;
            this.powerLevel = powerLevel;
            this.castTime = castTime;
            this.manaCost = manaCost;
            this.continuousCost = continuousCost;
            this.costInterval = costInterval;
        }

        public ResourceLocation spell() {
            return this.spell;
        }

        public int powerLevel() {
            return this.powerLevel;
        }

        public Optional<Integer> castTime() {
            return this.castTime;
        }

        public Optional<Integer> manaCost() {
            return this.manaCost;
        }

        public boolean continuousCost() {
            return this.continuousCost;
        }

        public int costInterval() {
            return this.costInterval;
        }
    }
}

