/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.otherworldorigins.OtherworldOrigins;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.edwinmindcraft.apoli.api.IDynamicFeatureConfiguration;
import io.github.edwinmindcraft.apoli.api.power.factory.EntityAction;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.network.casting.CastErrorPacket;
import io.redspace.ironsspellbooks.network.casting.OnCastStartedPacket;
import io.redspace.ironsspellbooks.network.casting.OnClientCastPacket;
import io.redspace.ironsspellbooks.network.casting.SyncTargetingDataPacket;
import io.redspace.ironsspellbooks.network.casting.UpdateCastingStatePacket;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.eventbus.api.Event;

public class CastSpellAction
extends EntityAction<Configuration> {
    private static final Map<UUID, ContinuousCastData> CONTINUOUS_CASTS = new HashMap<UUID, ContinuousCastData>();
    private static final double DEFAULT_RAYCAST_DISTANCE = 64.0;

    public CastSpellAction() {
        super(Configuration.CODEC);
    }

    public void execute(Configuration configuration, Entity entity) {
        LivingEntity target;
        AbstractSpell spell;
        if (!(entity instanceof LivingEntity)) {
            OtherworldOrigins.LOGGER.debug("Entity is not a LivingEntity: {}", (Object)entity);
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        String spellStr = configuration.spell().toString();
        ResourceLocation spellResourceLocation = ResourceLocation.m_135820_((String)spellStr);
        if (spellResourceLocation != null && spellResourceLocation.m_135827_().equals("minecraft")) {
            spellResourceLocation = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)spellResourceLocation.m_135815_());
        }
        if ((spell = SpellRegistry.getSpell((ResourceLocation)spellResourceLocation)) == null || "none".equals(spell.getSpellName())) {
            OtherworldOrigins.LOGGER.debug("No valid spell found for resource location {}", (Object)spellResourceLocation);
            return;
        }
        Level world = entity.m_9236_();
        if (world.f_46443_) {
            return;
        }
        int powerLevel = configuration.powerLevel();
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)livingEntity);
        if (magicData.isCasting()) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                OtherworldOrigins.LOGGER.debug("CastSpellAction: Player is still casting {}, cancelling previous cast", (Object)magicData.getCastingSpellId());
                Utils.serverSideCancelCast((ServerPlayer)serverPlayer);
            } else {
                OtherworldOrigins.LOGGER.debug("CastSpellAction: Entity is still casting {}, force-completing old cast", (Object)magicData.getCastingSpellId());
                AbstractSpell oldSpell = magicData.getCastingSpell().getSpell();
                oldSpell.onCast(world, magicData.getCastingSpellLevel(), livingEntity, magicData.getCastSource(), magicData);
                oldSpell.onServerCastComplete(world, magicData.getCastingSpellLevel(), livingEntity, magicData, false);
            }
            magicData.resetCastingState();
            magicData = MagicData.getPlayerMagicData((LivingEntity)livingEntity);
        }
        if ((target = this.findTarget(livingEntity, configuration.raycastDistance().orElse(64.0))) != null) {
            CastSpellAction.updateTargetData(livingEntity, (Entity)target, magicData, spell, e -> true);
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            this.castSpellForPlayer(configuration, spell, powerLevel, serverPlayer, magicData, world);
        } else if (livingEntity instanceof IMagicEntity) {
            IMagicEntity magicEntity = (IMagicEntity)livingEntity;
            magicEntity.initiateCastSpell(spell, powerLevel);
        } else if (spell.checkPreCastConditions(world, powerLevel, livingEntity, magicData)) {
            spell.onCast(world, powerLevel, livingEntity, CastSource.COMMAND, magicData);
            spell.onServerCastComplete(world, powerLevel, livingEntity, magicData, false);
        }
    }

    private void castSpellForPlayer(Configuration configuration, AbstractSpell spell, int powerLevel, ServerPlayer serverPlayer, MagicData magicData, Level world) {
        TargetEntityCastData targetingData;
        LivingEntity target;
        Optional<Integer> castTimeOpt = configuration.castTime();
        Optional<Integer> manaCostOpt = configuration.manaCost();
        CastResult castResult = spell.canBeCastedBy(powerLevel, CastSource.COMMAND, magicData, (Player)serverPlayer);
        if (castResult.message != null) {
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket(castResult.message));
        }
        if (!castResult.isSuccess() || !spell.checkPreCastConditions(world, powerLevel, (LivingEntity)serverPlayer, magicData) || MinecraftForge.EVENT_BUS.post((Event)new SpellPreCastEvent((Player)serverPlayer, spell.getSpellId(), powerLevel, spell.getSchoolType(), CastSource.COMMAND))) {
            return;
        }
        if (manaCostOpt.isPresent()) {
            int manaCost = manaCostOpt.get();
            if (!serverPlayer.m_150110_().f_35937_ && magicData.getMana() < (float)manaCost) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)CastErrorPacket.ErrorType.MANA);
                return;
            }
            if (!serverPlayer.m_150110_().f_35937_) {
                CastSpellAction.setManaWithEvent(serverPlayer, magicData, magicData.getMana() - (float)manaCost);
            }
        }
        if (serverPlayer.m_6117_()) {
            serverPlayer.m_5810_();
        }
        int effectiveCastTime = castTimeOpt.isPresent() ? castTimeOpt.get() : (spell.getCastType() == CastType.CONTINUOUS ? spell.getEffectiveCastTime(powerLevel, (LivingEntity)serverPlayer) : (spell.getCastType() == CastType.INSTANT ? 0 : spell.getEffectiveCastTime(powerLevel, (LivingEntity)serverPlayer)));
        if (configuration.continuousCost() && manaCostOpt.isPresent() && !serverPlayer.m_150110_().f_35937_) {
            int manaCost = manaCostOpt.get();
            int costInterval = configuration.costInterval();
            CONTINUOUS_CASTS.put(serverPlayer.m_20148_(), new ContinuousCastData(manaCost, costInterval, 0));
        }
        magicData.initiateCast(spell, powerLevel, effectiveCastTime, CastSource.COMMAND, "command");
        magicData.setPlayerCastingItem(ItemStack.f_41583_);
        spell.onServerPreCast(world, powerLevel, (LivingEntity)serverPlayer, magicData);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new UpdateCastingStatePacket(spell.getSpellId(), powerLevel, effectiveCastTime, CastSource.COMMAND, "command"));
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (Object)new OnCastStartedPacket(serverPlayer.m_20148_(), spell.getSpellId(), powerLevel));
        ICastData costInterval = magicData.getAdditionalCastData();
        if (costInterval instanceof TargetEntityCastData && (target = (targetingData = (TargetEntityCastData)costInterval).getTarget((ServerLevel)serverPlayer.m_9236_())) != null) {
            OtherworldOrigins.LOGGER.debug("Casting Spell {} with target {}", (Object)magicData.getCastingSpellId(), (Object)target.m_7755_().getString());
        }
        if (effectiveCastTime == 0) {
            spell.onCast(world, powerLevel, (LivingEntity)serverPlayer, CastSource.COMMAND, magicData);
            spell.onServerCastComplete(world, powerLevel, (LivingEntity)serverPlayer, magicData, false);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new OnClientCastPacket(spell.getSpellId(), powerLevel, CastSource.COMMAND, magicData.getAdditionalCastData()));
        }
    }

    @Nullable
    private LivingEntity findTarget(LivingEntity caster, double distance) {
        AABB searchBox;
        Vec3 eyePos = caster.m_146892_();
        Vec3 lookVec = caster.m_20154_();
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(distance));
        HitResult blockHit = CastSpellAction.clipIgnoringPassableBlocks((BlockGetter)caster.m_9236_(), eyePos, endPos, (Entity)caster);
        double searchDist = blockHit.m_6662_() != HitResult.Type.MISS ? blockHit.m_82450_().m_82554_(eyePos) : distance;
        Vec3 searchEnd = eyePos.m_82549_(lookVec.m_82490_(searchDist));
        EntityHitResult entityHit = this.raycastForEntity((Entity)caster, eyePos, searchEnd, searchBox = caster.m_20191_().m_82369_(lookVec.m_82490_(searchDist)).m_82400_(1.0), e -> {
            PartEntity part;
            return !e.m_5833_() && e.m_6087_() && (e instanceof LivingEntity || e instanceof PartEntity && (part = (PartEntity)e).getParent() instanceof LivingEntity);
        }, searchDist);
        if (entityHit != null) {
            PartEntity part;
            Entity entity;
            Entity hitEntity = entityHit.m_82443_();
            if (hitEntity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)hitEntity;
                return target;
            }
            if (hitEntity instanceof PartEntity && (entity = (part = (PartEntity)hitEntity).getParent()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                return target;
            }
        }
        return null;
    }

    private static HitResult clipIgnoringPassableBlocks(BlockGetter level, Vec3 start, Vec3 end, Entity entity) {
        return (HitResult)BlockGetter.m_151361_((Vec3)start, (Vec3)end, (Object)level, (blockGetter, blockPos) -> {
            BlockState blockState = blockGetter.m_8055_(blockPos);
            if (CastSpellAction.isPassableBlock(blockGetter, blockPos, blockState)) {
                return null;
            }
            VoxelShape shape = blockState.m_60812_(blockGetter, blockPos);
            if (shape.m_83281_()) {
                return null;
            }
            return shape.m_83220_(start, end, blockPos);
        }, blockGetter -> {
            Vec3 direction = start.m_82546_(end);
            return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.m_122366_((double)direction.f_82479_, (double)direction.f_82480_, (double)direction.f_82481_), (BlockPos)BlockPos.m_274446_((Position)end));
        });
    }

    private static boolean isPassableBlock(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.m_60812_(level, pos).m_83281_()) {
            return true;
        }
        return state.m_60800_(level, pos) == 0.0f;
    }

    @Nullable
    private EntityHitResult raycastForEntity(Entity caster, Vec3 start, Vec3 end, AABB bounds, Predicate<Entity> filter, double maxDistance) {
        double closestDist = maxDistance;
        Entity closestEntity = null;
        Vec3 hitPos = null;
        for (Entity entity : caster.m_9236_().m_6249_(caster, bounds, filter)) {
            double dist;
            AABB entityBounds = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Optional optional = entityBounds.m_82371_(start, end);
            if (!optional.isPresent() || !((dist = start.m_82554_((Vec3)optional.get())) < closestDist)) continue;
            closestEntity = entity;
            hitPos = (Vec3)optional.get();
            closestDist = dist;
        }
        return closestEntity != null ? new EntityHitResult(closestEntity, hitPos) : null;
    }

    public static void updateTargetData(LivingEntity caster, Entity entityHit, MagicData playerMagicData, AbstractSpell spell, Predicate<LivingEntity> filter) {
        LivingEntity livingParent;
        PartEntity partEntity;
        Entity entity;
        LivingEntity livingEntity;
        LivingEntity livingTarget = null;
        if (entityHit instanceof LivingEntity && filter.test(livingEntity = (LivingEntity)entityHit)) {
            livingTarget = livingEntity;
        } else if (entityHit instanceof PartEntity && (entity = (partEntity = (PartEntity)entityHit).getParent()) instanceof LivingEntity && filter.test(livingParent = (LivingEntity)entity)) {
            livingTarget = livingParent;
        }
        if (livingTarget != null) {
            playerMagicData.setAdditionalCastData((ICastData)new TargetEntityCastData(livingTarget));
            if (caster instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)caster;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new SyncTargetingDataPacket(livingTarget, spell));
            }
            if (livingTarget instanceof ServerPlayer) {
                ServerPlayer targetPlayer = (ServerPlayer)livingTarget;
                Utils.sendTargetedNotification((ServerPlayer)targetPlayer, (LivingEntity)caster, (AbstractSpell)spell);
            }
        } else if (caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
        }
    }

    public static void onSpellTick(ServerPlayer player, MagicData magicData) {
        UUID playerId = player.m_20148_();
        ContinuousCastData data = CONTINUOUS_CASTS.get(playerId);
        if (data != null) {
            ++data.ticksElapsed;
            if (data.ticksElapsed >= data.costInterval) {
                data.ticksElapsed = 0;
                if (magicData.getMana() >= (float)data.manaCost) {
                    CastSpellAction.setManaWithEvent(player, magicData, magicData.getMana() - (float)data.manaCost);
                    OtherworldOrigins.LOGGER.debug("Draining mana: {}. Remaining mana: {}", (Object)data.manaCost, (Object)Float.valueOf(magicData.getMana()));
                } else {
                    Utils.serverSideCancelCast((ServerPlayer)player);
                    CONTINUOUS_CASTS.remove(playerId);
                }
            }
        }
    }

    private static void setManaWithEvent(ServerPlayer player, MagicData magicData, float newMana) {
        ChangeManaEvent event = new ChangeManaEvent((Player)player, magicData, magicData.getMana(), newMana);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            magicData.setMana(event.getNewMana());
        }
    }

    public static void onSpellEnd(ServerPlayer player) {
        CONTINUOUS_CASTS.remove(player.m_20148_());
    }

    public static void registerContinuousCast(UUID playerId, int manaCost, int costInterval) {
        CONTINUOUS_CASTS.put(playerId, new ContinuousCastData(manaCost, costInterval, 0));
    }

    public static class Configuration
    implements IDynamicFeatureConfiguration {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SerializableDataTypes.IDENTIFIER.fieldOf("spell").forGetter(Configuration::spell), (App)Codec.INT.optionalFieldOf("power_level", (Object)1).forGetter(Configuration::powerLevel), (App)Codec.INT.optionalFieldOf("cast_time").forGetter(Configuration::castTime), (App)Codec.INT.optionalFieldOf("mana_cost").forGetter(Configuration::manaCost), (App)Codec.BOOL.optionalFieldOf("continuous_cost", (Object)false).forGetter(Configuration::continuousCost), (App)Codec.INT.optionalFieldOf("cost_interval", (Object)20).forGetter(Configuration::costInterval), (App)Codec.DOUBLE.optionalFieldOf("raycast_distance").forGetter(Configuration::raycastDistance)).apply((Applicative)instance, Configuration::new));
        private final ResourceLocation spell;
        private final int powerLevel;
        private final Optional<Integer> castTime;
        private final Optional<Integer> manaCost;
        private final boolean continuousCost;
        private final int costInterval;
        private final Optional<Double> raycastDistance;

        public Configuration(ResourceLocation spell, int powerLevel, Optional<Integer> castTime, Optional<Integer> manaCost, boolean continuousCost, int costInterval, Optional<Double> raycastDistance) {
            this.spell = spell;
            this.powerLevel = powerLevel;
            this.castTime = castTime;
            this.manaCost = manaCost;
            this.continuousCost = continuousCost;
            this.costInterval = costInterval;
            this.raycastDistance = raycastDistance;
        }

        public ResourceLocation spell() {
            return this.spell;
        }

        public int powerLevel() {
            return this.powerLevel;
        }

        public Optional<Integer> castTime() {
            return this.castTime;
        }

        public Optional<Integer> manaCost() {
            return this.manaCost;
        }

        public boolean continuousCost() {
            return this.continuousCost;
        }

        public int costInterval() {
            return this.costInterval;
        }

        public Optional<Double> raycastDistance() {
            return this.raycastDistance;
        }
    }

    private static class ContinuousCastData {
        final int manaCost;
        final int costInterval;
        int ticksElapsed;

        ContinuousCastData(int manaCost, int costInterval, int ticksElapsed) {
            this.manaCost = manaCost;
            this.costInterval = costInterval;
            this.ticksElapsed = ticksElapsed;
        }
    }
}

