/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins;

import com.mojang.logging.LogUtils;
import dev.muon.otherworldorigins.action.ModActions;
import dev.muon.otherworldorigins.attribute.ModAttributes;
import dev.muon.otherworldorigins.condition.ModConditions;
import dev.muon.otherworldorigins.config.OtherworldOriginsConfig;
import dev.muon.otherworldorigins.entity.ModEntities;
import dev.muon.otherworldorigins.item.ModItems;
import dev.muon.otherworldorigins.network.CheckFeatScreenMessage;
import dev.muon.otherworldorigins.network.CloseCurrentScreenMessage;
import dev.muon.otherworldorigins.network.GiveStarterKitMessage;
import dev.muon.otherworldorigins.network.OpenFinalConfirmScreenMessage;
import dev.muon.otherworldorigins.network.RequestLayerValidationMessage;
import dev.muon.otherworldorigins.network.ResetOriginsMessage;
import dev.muon.otherworldorigins.network.ResetValidationAttemptsMessage;
import dev.muon.otherworldorigins.network.RespecAptitudesMessage;
import dev.muon.otherworldorigins.network.SendFeatLayersMessage;
import dev.muon.otherworldorigins.network.SendValidatedLayersMessage;
import dev.muon.otherworldorigins.power.ModPowers;
import dev.muon.otherworldorigins.restrictions.SpellCategoryMapper;
import dev.muon.otherworldorigins.restrictions.SpellRestrictions;
import dev.muon.otherworldorigins.skills.ModPassives;
import dev.muon.otherworldorigins.skills.ModSkills;
import dev.muon.otherworldorigins.spells.ModSpells;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="otherworldorigins")
public class OtherworldOrigins {
    public static final String MODID = "otherworldorigins";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)OtherworldOrigins.loc("main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }

    public OtherworldOrigins(FMLJavaModLoadingContext context) {
        LOGGER.info("Loading Otherworld Origins");
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)OtherworldOriginsConfig.SPEC);
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::onConfigReload);
        modEventBus.addListener(this::commonSetup);
        ModAttributes.register(modEventBus);
        ModEntities.register(modEventBus);
        ModItems.register(modEventBus);
        ModActions.register(modEventBus);
        ModConditions.register(modEventBus);
        ModPowers.register(modEventBus);
        ModSpells.register(modEventBus);
        ModPassives.register(modEventBus);
        ModSkills.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        OtherworldOrigins.registerMessages();
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == OtherworldOriginsConfig.SPEC) {
            SpellRestrictions.initializeFromConfig();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == OtherworldOriginsConfig.SPEC) {
            SpellRestrictions.initializeFromConfig();
            SpellCategoryMapper.initialize();
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        SpellCategoryMapper.initialize();
    }

    private static int nextPacketId() {
        return packetId++;
    }

    public static void registerMessages() {
        CHANNEL.messageBuilder(CloseCurrentScreenMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_CLIENT).encoder((msg, buf) -> {}).decoder(buf -> new CloseCurrentScreenMessage()).consumerMainThread(CloseCurrentScreenMessage::handle).add();
        CHANNEL.messageBuilder(ResetOriginsMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_SERVER).encoder(ResetOriginsMessage::encode).decoder(ResetOriginsMessage::decode).consumerMainThread(ResetOriginsMessage::handle).add();
        CHANNEL.messageBuilder(CheckFeatScreenMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_SERVER).encoder(CheckFeatScreenMessage::encode).decoder(CheckFeatScreenMessage::decode).consumerMainThread(CheckFeatScreenMessage::handle).add();
        CHANNEL.messageBuilder(RespecAptitudesMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_SERVER).encoder(RespecAptitudesMessage::encode).decoder(RespecAptitudesMessage::decode).consumerMainThread(RespecAptitudesMessage::handle).add();
        CHANNEL.messageBuilder(RequestLayerValidationMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_SERVER).encoder(RequestLayerValidationMessage::encode).decoder(RequestLayerValidationMessage::decode).consumerMainThread(RequestLayerValidationMessage::handle).add();
        CHANNEL.messageBuilder(SendValidatedLayersMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_CLIENT).encoder(SendValidatedLayersMessage::encode).decoder(SendValidatedLayersMessage::decode).consumerMainThread(SendValidatedLayersMessage::handle).add();
        CHANNEL.messageBuilder(SendFeatLayersMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_CLIENT).encoder(SendFeatLayersMessage::encode).decoder(SendFeatLayersMessage::decode).consumerMainThread(SendFeatLayersMessage::handle).add();
        CHANNEL.messageBuilder(ResetValidationAttemptsMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_CLIENT).encoder(ResetValidationAttemptsMessage::encode).decoder(ResetValidationAttemptsMessage::decode).consumerMainThread(ResetValidationAttemptsMessage::handle).add();
        CHANNEL.messageBuilder(OpenFinalConfirmScreenMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_CLIENT).encoder(OpenFinalConfirmScreenMessage::encode).decoder(OpenFinalConfirmScreenMessage::decode).consumerMainThread(OpenFinalConfirmScreenMessage::handle).add();
        CHANNEL.messageBuilder(GiveStarterKitMessage.class, OtherworldOrigins.nextPacketId(), NetworkDirection.PLAY_TO_SERVER).encoder(GiveStarterKitMessage::encode).decoder(GiveStarterKitMessage::decode).consumerMainThread(GiveStarterKitMessage::handle).add();
    }
}

