/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldorigins;

import com.seniors.justlevelingfork.registry.RegistrySkills;
import com.seniors.justlevelingfork.registry.skills.Skill;
import dev.muon.otherworldorigins.OtherworldOrigins;
import dev.muon.otherworldorigins.network.CloseCurrentScreenMessage;
import dev.muon.otherworldorigins.power.ModPowers;
import dev.muon.otherworldorigins.power.ModifyCriticalHitPower;
import dev.muon.otherworldorigins.restrictions.EnchantmentRestrictions;
import dev.muon.otherworldorigins.restrictions.SpellRestrictions;
import dev.shadowsoffire.apotheosis.Apotheosis;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2COpenOriginScreen;
import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.entity.spells.AbstractConeProjectile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="otherworldorigins", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    private static final int CONE_DURATION_TICKS = 10;
    private static final Map<Integer, Integer> activeCones = new HashMap<Integer, Integer>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            activeCones.entrySet().removeIf(entry -> {
                int coneId = (Integer)entry.getKey();
                int age = (Integer)entry.getValue();
                if (age >= 10) {
                    for (Level level : event.getServer().m_129785_()) {
                        AbstractConeProjectile cone = (AbstractConeProjectile)level.m_6815_(coneId);
                        if (cone == null) continue;
                        cone.m_146870_();
                        return true;
                    }
                    return true;
                }
                entry.setValue(age + 1);
                return false;
            });
        }
    }

    @SubscribeEvent
    public static void onSpellPreCast(SpellPreCastEvent event) {
        if (event.getCastSource() == CastSource.COMMAND || event.getCastSource() == CastSource.SCROLL) {
            return;
        }
        if (!SpellRestrictions.isSpellAllowed(event.getEntity(), SpellRegistry.getSpell((String)event.getSpellId()))) {
            event.setCanceled(true);
            event.getEntity().m_5661_((Component)Component.m_237113_((String)"You are not attuned to this type of magic!").m_130940_(ChatFormatting.RED), true);
        }
    }

    @SubscribeEvent
    public static void modifySpellLevels(ModifySpellLevelEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Skill skill = (Skill)((IForgeRegistry)RegistrySkills.SKILLS_REGISTRY.get()).getValue(new ResourceLocation("otherworldorigins", "wisdom"));
            if (skill != null && skill.isEnabled(player)) {
                event.addLevels(1);
            }
        }
    }

    public static void trackConeProjectile(AbstractConeProjectile coneProjectile) {
        activeCones.put(coneProjectile.m_19879_(), 0);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!Apotheosis.enableAdventure) {
            serverPlayer.m_240418_((Component)Component.m_237113_((String)"Otherworld Origins requires the Apotheosis Adventure Module enabled to work correctly. Please enable it in /config/apotheosis/apotheosis.cfg, or you will be missing origins!"), true);
        }
        MappedRegistry layerRegistry = OriginsAPI.getLayersRegistry((MinecraftServer)player.m_9236_().m_7654_());
        IOriginContainer originContainer = IOriginContainer.get((Entity)player).resolve().orElse(null);
        if (originContainer == null) {
            return;
        }
        ArrayList<Holder.Reference> missingOriginLayers = new ArrayList<Holder.Reference>();
        for (OriginLayer layer : layerRegistry) {
            Set availableOrigins;
            Holder.Reference layerHolder = layerRegistry.m_246971_((ResourceKey)layerRegistry.m_7854_((Object)layer).orElseThrow());
            ResourceKey currentOrigin = originContainer.getOrigin((Holder)layerHolder);
            if (!currentOrigin.m_135782_().equals((Object)new ResourceLocation("origins", "empty")) || (availableOrigins = layer.origins(player)).isEmpty()) continue;
            missingOriginLayers.add(layerHolder);
        }
        if (!missingOriginLayers.isEmpty()) {
            PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> serverPlayer);
            OtherworldOrigins.CHANNEL.send(target, (Object)new CloseCurrentScreenMessage());
            OriginsCommon.CHANNEL.send(target, (Object)originContainer.getSynchronizationPacket());
            OriginsCommon.CHANNEL.send(target, (Object)new S2COpenOriginScreen(false));
            originContainer.synchronize();
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        List playerPowers;
        float totalModifier;
        Player targetPlayer;
        IPowerContainer targetPowerContainer;
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof Player && (targetPowerContainer = ApoliAPI.getPowerContainer((Entity)(targetPlayer = (Player)entity))) != null && targetPowerContainer.hasPower((PowerFactory)ModPowers.PREVENT_CRITICAL_HIT.get())) {
            event.setDamageModifier(1.0f);
            event.setResult(Event.Result.DENY);
            return;
        }
        IPowerContainer powerContainer = ApoliAPI.getPowerContainer((Entity)player);
        if (powerContainer != null && (totalModifier = (playerPowers = powerContainer.getPowers((PowerFactory)ModPowers.MODIFY_CRITICAL_HIT.get())).stream().map(holder -> (ModifyCriticalHitPower.Configuration)((ConfiguredPower)holder.m_203334_()).getConfiguration()).map(ModifyCriticalHitPower.Configuration::amount).reduce(Float.valueOf(0.0f), Float::sum).floatValue()) != 0.0f) {
            float newDamageModifier = event.getDamageModifier() * (1.0f + totalModifier);
            event.setDamageModifier(newDamageModifier);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        ItemStack weapon = player.m_21205_();
        float damageReduction = 0.0f;
        if (!EnchantmentRestrictions.isEnchantmentAllowed(player, Enchantments.f_44977_)) {
            damageReduction += ForgeEvents.calculateDamageBonus(weapon, Enchantments.f_44977_, MobType.f_21640_);
        }
        if (!EnchantmentRestrictions.isEnchantmentAllowed(player, Enchantments.f_44978_)) {
            damageReduction += ForgeEvents.calculateDamageBonus(weapon, Enchantments.f_44978_, MobType.f_21641_);
        }
        if (!EnchantmentRestrictions.isEnchantmentAllowed(player, Enchantments.f_44979_)) {
            damageReduction += ForgeEvents.calculateDamageBonus(weapon, Enchantments.f_44979_, MobType.f_21642_);
        }
        if (damageReduction > 0.0f) {
            event.setAmount(Math.max(0.0f, event.getAmount() - damageReduction));
        }
    }

    private static float calculateDamageBonus(ItemStack weapon, Enchantment enchantment, MobType mobType) {
        int level = weapon.getEnchantmentLevel(enchantment);
        if (level > 0) {
            if (mobType == MobType.f_21640_) {
                return 1.0f + (float)level * 0.5f;
            }
            return (float)level * 1.5f;
        }
        return 0.0f;
    }
}

