/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.util;

import com.gametechbc.traveloptics.init.TravelopticsKeybinds;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class TravelopticsKeybindManager {
    private static final Map<KeyMapping, Boolean> keyStates = new HashMap<KeyMapping, Boolean>();

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasKeyJustPressed(KeyMapping key) {
        boolean currentState = key.m_90857_();
        boolean previousState = keyStates.getOrDefault(key, false);
        keyStates.put(key, currentState);
        return currentState && !previousState;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean wasKeyJustReleased(KeyMapping key) {
        boolean currentState = key.m_90857_();
        boolean previousState = keyStates.getOrDefault(key, false);
        keyStates.put(key, currentState);
        return !currentState && previousState;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isKeyDown(int keyType) {
        if (keyType == 1) {
            return TravelopticsKeybinds.KEY_Z.m_90857_();
        }
        if (keyType == 2) {
            return TravelopticsKeybinds.KEY_X.m_90857_();
        }
        if (keyType == 3) {
            return TravelopticsKeybinds.KEY_C.m_90857_();
        }
        if (keyType == 4) {
            return TravelopticsKeybinds.KEY_B.m_90857_();
        }
        return false;
    }

    public static Player getClientSidePlayer() {
        return (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateKeyStates() {
        keyStates.put(TravelopticsKeybinds.KEY_Z, TravelopticsKeybinds.KEY_Z.m_90857_());
        keyStates.put(TravelopticsKeybinds.KEY_X, TravelopticsKeybinds.KEY_X.m_90857_());
        keyStates.put(TravelopticsKeybinds.KEY_C, TravelopticsKeybinds.KEY_C.m_90857_());
        keyStates.put(TravelopticsKeybinds.KEY_B, TravelopticsKeybinds.KEY_B.m_90857_());
    }
}

