/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.util;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class MagnetRarityColorHelper {
    public static MutableComponent createWaveGradient(String text) {
        MutableComponent result = Component.m_237113_((String)"");
        long currentTime = System.currentTimeMillis();
        float waveTime = (float)(currentTime % 3000L) / 3000.0f;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            float smoothWave = MagnetRarityColorHelper.getSmoothWave(i, length, waveTime);
            int color = MagnetRarityColorHelper.interpolateColor(16711722, 24815, smoothWave);
            result.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_6270_(Style.f_131099_.m_178520_(color)));
        }
        return result;
    }

    private static float getSmoothWave(float i, int length, float waveTime) {
        float diagonalOffset;
        float charPosition = i / (float)Math.max(1, length - 1);
        float wavePosition = (charPosition - waveTime + (diagonalOffset = charPosition * 0.3f)) % 1.0f;
        if (wavePosition < 0.0f) {
            wavePosition += 1.0f;
        }
        return (float)(Math.sin((double)wavePosition * Math.PI * 2.0 - 1.5707963267948966) * 0.5 + 0.5);
    }

    private static int interpolateColor(int color1, int color2, float ratio) {
        ratio = Math.max(0.0f, Math.min(1.0f, ratio));
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * ratio);
        int g = (int)((float)g1 + (float)(g2 - g1) * ratio);
        int b = (int)((float)b1 + (float)(b2 - b1) * ratio);
        return r << 16 | g << 8 | b;
    }
}

