/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.lightning;

import com.gametechbc.traveloptics.api.particle.CylinderParticleManager;
import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.api.spells.AbstractUniqueSpell;
import com.gametechbc.traveloptics.api.utils.SummonCheckHelper;
import com.gametechbc.traveloptics.api.utils.TOGeneralUtils;
import com.gametechbc.traveloptics.config.SpellsConfig;
import com.gametechbc.traveloptics.entity.summons.SummonedMagnetron;
import com.gametechbc.traveloptics.util.SummonTypes;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonedEntitiesCastData;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class MagnetronDeploymentSpell
extends AbstractUniqueSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "magnetron_deployment");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.LIGHTNING_RESOURCE).setMaxLevel(1).setCooldownSeconds(270.0).build();

    public MagnetronDeploymentSpell() {
        this.manaCostPerLevel = 0;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 60;
        this.baseManaCost = 250;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)ACSoundRegistry.MAGNETRON_ASSEMBLE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)ACSoundRegistry.MAGNETRON_STEP.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
                return true;
            }
            if (((Boolean)SpellsConfig.limitMinibossSummons.get()).booleanValue() && SummonCheckHelper.hasActiveSummons(player, 128.0, SummonTypes.getEliteSummons())) {
                player.m_5661_((Component)Component.m_237115_((String)"spell.traveloptics.summon_elite.warning").m_130940_(ChatFormatting.RED), true);
                return false;
            }
        }
        return true;
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        CylinderParticleManager.spawnParticles(level, (Entity)entity, 1, (ParticleOptions)ACParticleRegistry.MAGNET_LIGHTNING.get(), ParticleDirection.UPWARD, 2.0, 1.0, 0.0);
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return 2;
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (SummonManager.recastFinishedHelper((ServerPlayer)serverPlayer, (RecastInstance)recastInstance, (RecastResult)recastResult, (ICastDataSerializable)castDataSerializable)) {
            super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
        }
    }

    public ICastDataSerializable getEmptyCastData() {
        return new SummonedEntitiesCastData();
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        PlayerRecasts recasts = playerMagicData.getPlayerRecasts();
        if (!recasts.hasRecastForSpell((AbstractSpell)this)) {
            SummonedEntitiesCastData summonedEntitiesCastData = new SummonedEntitiesCastData();
            int summonTime = 12000;
            double offset = 2.0;
            double angle = Math.toRadians(-entity.m_146908_());
            double xOffset = offset * Math.cos(angle);
            double zOffset = offset * Math.sin(angle);
            SummonedMagnetron magnetron = new SummonedMagnetron(world, entity);
            magnetron.m_6034_(entity.m_20185_() + xOffset, entity.m_20186_(), entity.m_20189_() + zOffset);
            world.m_7967_((Entity)magnetron);
            SummonManager.initSummon((Entity)entity, (Entity)magnetron, (int)summonTime, (SummonedEntitiesCastData)summonedEntitiesCastData);
            RecastInstance recastInstance = new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), summonTime, castSource, (ICastDataSerializable)summonedEntitiesCastData);
            recasts.addRecast(recastInstance, playerMagicData);
            MagicManager.spawnParticles((Level)world, (ParticleOptions)((ParticleOptions)ACParticleRegistry.MAGNET_LIGHTNING.get()), (double)(entity.m_20185_() + xOffset), (double)entity.m_20186_(), (double)(entity.m_20189_() + zOffset), (int)2, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(25, entity.m_20182_(), 25.0f));
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return TOGeneralUtils.buildSummonInfo(List.of((EntityType)ACEntityRegistry.MAGNETRON.get()), false, Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }
}

