/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.summons;

import com.gametechbc.traveloptics.api.entity.mobs.MagicForlornSummon;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import com.github.alexmodguy.alexscaves.server.entity.living.HullbreakerEntity;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericProtectOwnerTargetGoal;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SummonedHullbreaker
extends HullbreakerEntity
implements MagicForlornSummon {
    private float riddenSpeed;

    public SummonedHullbreaker(EntityType<? extends HullbreakerEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 0;
        this.riddenSpeed = 1.5f;
    }

    public SummonedHullbreaker(Level level, LivingEntity owner) {
        this((EntityType<? extends HullbreakerEntity>)((EntityType)TravelopticsEntities.SUMMONED_HULLBREAKER.get()), level);
        SummonManager.setOwner((Entity)this, (Entity)owner);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_148105_().removeIf(goal -> goal.m_26015_() instanceof HurtByTargetGoal || goal.m_26015_() instanceof NearestAttackableTargetGoal);
        this.f_21346_.m_25352_(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, () -> ((SummonedHullbreaker)this).getSummoner()));
        this.f_21346_.m_25352_(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, () -> ((SummonedHullbreaker)this).getSummoner()));
        this.f_21346_.m_25352_(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, () -> ((SummonedHullbreaker)this).getSummoner()));
        this.f_21346_.m_25352_(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new GenericProtectOwnerTargetGoal((Mob)this, () -> ((SummonedHullbreaker)this).getSummoner()));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (this.m_20160_()) {
            return super.m_6071_(pPlayer, pHand);
        }
        if (pPlayer == this.getSummoner()) {
            this.doPlayerRide(pPlayer);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected void doPlayerRide(Player pPlayer) {
        if (!this.m_9236_().f_46443_) {
            pPlayer.m_146922_(this.m_146908_());
            pPlayer.m_146926_(this.m_146909_());
            pPlayer.m_20329_((Entity)this);
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            return (Mob)entity;
        }
        entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    protected void m_274498_(Player player, Vec3 movementVector) {
        super.m_274498_(player, movementVector);
        this.f_19859_ = this.m_146908_();
        this.m_146922_(player.m_146908_());
        this.m_146926_(player.m_146909_());
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20883_ = this.f_19859_;
        this.f_20885_ = this.m_146908_();
        if (this.m_5842_()) {
            Vec3 riddenInput = this.m_274312_(player, movementVector);
            if (!riddenInput.equals((Object)Vec3.f_82478_)) {
                double speed = this.m_245547_(player);
                Vec3 movement = riddenInput.m_82541_().m_82490_(speed);
                this.m_20256_(movement);
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
            if (!player.m_21023_(MobEffects.f_19608_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 40, 0, false, false, true));
            }
        } else {
            this.m_20256_(Vec3.f_82478_);
            if (player.m_21023_(MobEffects.f_19608_)) {
                player.m_21195_(MobEffects.f_19608_);
            }
        }
    }

    protected Vec3 m_274312_(Player player, Vec3 playerMovementInput) {
        float strafe = player.f_20900_ * 0.5f;
        float forward = player.f_20902_;
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        if (this.m_5842_()) {
            Vec3 lookDirection = player.m_20154_().m_82541_();
            Vec3 movementVector = new Vec3(lookDirection.f_82479_ * (double)(forward *= 0.3f) + lookDirection.f_82481_ * (double)(strafe *= 0.3f), lookDirection.f_82480_ * (double)forward, lookDirection.f_82481_ * (double)forward - lookDirection.f_82479_ * (double)strafe);
            return movementVector;
        }
        return Vec3.f_82478_;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20365_(passenger)) {
            float lowerSeatOffset = -0.3f;
            float forwardOffset = 2.2f;
            Vec3 offset = new Vec3(0.0, (double)lowerSeatOffset, (double)forwardOffset).m_82524_((float)Math.toRadians(-this.f_20883_));
            moveFunction.m_20372_(passenger, this.m_20185_() + offset.f_82479_, this.m_20186_() + offset.f_82480_ + this.m_6048_(), this.m_20189_() + offset.f_82481_);
        } else {
            super.m_19956_(passenger, moveFunction);
        }
    }

    protected float m_245547_(Player player) {
        if (this.m_5842_()) {
            return (float)this.m_21133_(Attributes.f_22279_) * this.riddenSpeed;
        }
        return 0.0f;
    }

    public boolean isRidingMode() {
        return this.m_20160_() && this.m_6688_() != null;
    }

    public float getStepHeight() {
        return this.isRidingMode() ? 5.0f : super.getStepHeight();
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.m_6667_(pDamageSource);
    }

    public void onRemovedFromWorld() {
        this.onRemovedHelper((Entity)this);
        super.onRemovedFromWorld();
    }

    public boolean m_7327_(Entity pEntity) {
        return Utils.doMeleeAttack((Mob)this, (Entity)pEntity, (DamageSource)((AbstractSpell)TravelopticsSpells.ECHO_OF_THE_ABYSS_SPELL.get()).getDamageSource((Entity)this, this.getSummoner()));
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || this.isAlliedHelper(pEntity);
    }

    public void onUnSummon() {
        if (!this.m_9236_().f_46443_) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)TravelopticsParticleHelper.WATER_SPARKS, (double)this.m_20185_(), (double)(this.m_20186_() + 1.5), (double)this.m_20189_(), (int)30, (double)0.0, (double)0.0, (double)0.0, (double)0.05, (boolean)false);
            this.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_269533_(DamageTypeTags.f_268738_) && this.shouldIgnoreDamage(pSource)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected boolean m_8028_() {
        return false;
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.riddenSpeed = compoundTag.m_128457_("RiddenSpeed");
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("RiddenSpeed", this.riddenSpeed);
    }
}

